/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.List;
import java.util.Random;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.BlockAnvil;
import net.minecraft.server.BlockBeacon;
import net.minecraft.server.BlockBed;
import net.minecraft.server.BlockBloodStone;
import net.minecraft.server.BlockBookshelf;
import net.minecraft.server.BlockBrewingStand;
import net.minecraft.server.BlockCactus;
import net.minecraft.server.BlockCake;
import net.minecraft.server.BlockCarpet;
import net.minecraft.server.BlockCarrots;
import net.minecraft.server.BlockCauldron;
import net.minecraft.server.BlockChest;
import net.minecraft.server.BlockClay;
import net.minecraft.server.BlockCloth;
import net.minecraft.server.BlockCobbleWall;
import net.minecraft.server.BlockCocoa;
import net.minecraft.server.BlockCommand;
import net.minecraft.server.BlockCrops;
import net.minecraft.server.BlockDaylightDetector;
import net.minecraft.server.BlockDeadBush;
import net.minecraft.server.BlockDirt;
import net.minecraft.server.BlockDispenser;
import net.minecraft.server.BlockDoor;
import net.minecraft.server.BlockDragonEgg;
import net.minecraft.server.BlockDropper;
import net.minecraft.server.BlockEnchantmentTable;
import net.minecraft.server.BlockEnderChest;
import net.minecraft.server.BlockEnderPortal;
import net.minecraft.server.BlockEnderPortalFrame;
import net.minecraft.server.BlockFence;
import net.minecraft.server.BlockFenceGate;
import net.minecraft.server.BlockFire;
import net.minecraft.server.BlockFlower;
import net.minecraft.server.BlockFlowerPot;
import net.minecraft.server.BlockFlowing;
import net.minecraft.server.BlockFluids;
import net.minecraft.server.BlockFurnace;
import net.minecraft.server.BlockGlass;
import net.minecraft.server.BlockGrass;
import net.minecraft.server.BlockGravel;
import net.minecraft.server.BlockHay;
import net.minecraft.server.BlockHopper;
import net.minecraft.server.BlockHugeMushroom;
import net.minecraft.server.BlockIce;
import net.minecraft.server.BlockJukeBox;
import net.minecraft.server.BlockLadder;
import net.minecraft.server.BlockLeaves;
import net.minecraft.server.BlockLever;
import net.minecraft.server.BlockLightStone;
import net.minecraft.server.BlockLockedChest;
import net.minecraft.server.BlockLog;
import net.minecraft.server.BlockLongGrass;
import net.minecraft.server.BlockMelon;
import net.minecraft.server.BlockMinecartDetector;
import net.minecraft.server.BlockMinecartTrack;
import net.minecraft.server.BlockMobSpawner;
import net.minecraft.server.BlockMonsterEggs;
import net.minecraft.server.BlockMushroom;
import net.minecraft.server.BlockMycel;
import net.minecraft.server.BlockNetherWart;
import net.minecraft.server.BlockNote;
import net.minecraft.server.BlockObsidian;
import net.minecraft.server.BlockOre;
import net.minecraft.server.BlockOreBlock;
import net.minecraft.server.BlockPiston;
import net.minecraft.server.BlockPistonExtension;
import net.minecraft.server.BlockPistonMoving;
import net.minecraft.server.BlockPortal;
import net.minecraft.server.BlockPotatoes;
import net.minecraft.server.BlockPoweredRail;
import net.minecraft.server.BlockPressurePlateBinary;
import net.minecraft.server.BlockPressurePlateWeighted;
import net.minecraft.server.BlockPumpkin;
import net.minecraft.server.BlockQuartz;
import net.minecraft.server.BlockRedstone;
import net.minecraft.server.BlockRedstoneComparator;
import net.minecraft.server.BlockRedstoneLamp;
import net.minecraft.server.BlockRedstoneOre;
import net.minecraft.server.BlockRedstoneTorch;
import net.minecraft.server.BlockRedstoneWire;
import net.minecraft.server.BlockReed;
import net.minecraft.server.BlockRepeater;
import net.minecraft.server.BlockSand;
import net.minecraft.server.BlockSandStone;
import net.minecraft.server.BlockSapling;
import net.minecraft.server.BlockSign;
import net.minecraft.server.BlockSkull;
import net.minecraft.server.BlockSlowSand;
import net.minecraft.server.BlockSmoothBrick;
import net.minecraft.server.BlockSnow;
import net.minecraft.server.BlockSnowBlock;
import net.minecraft.server.BlockSoil;
import net.minecraft.server.BlockSponge;
import net.minecraft.server.BlockStairs;
import net.minecraft.server.BlockStationary;
import net.minecraft.server.BlockStem;
import net.minecraft.server.BlockStep;
import net.minecraft.server.BlockStepAbstract;
import net.minecraft.server.BlockStone;
import net.minecraft.server.BlockStoneButton;
import net.minecraft.server.BlockTNT;
import net.minecraft.server.BlockThinFence;
import net.minecraft.server.BlockTorch;
import net.minecraft.server.BlockTrapdoor;
import net.minecraft.server.BlockTripwire;
import net.minecraft.server.BlockTripwireHook;
import net.minecraft.server.BlockVine;
import net.minecraft.server.BlockWaterLily;
import net.minecraft.server.BlockWeb;
import net.minecraft.server.BlockWood;
import net.minecraft.server.BlockWoodButton;
import net.minecraft.server.BlockWoodStep;
import net.minecraft.server.BlockWorkbench;
import net.minecraft.server.CreativeModeTab;
import net.minecraft.server.EnchantmentManager;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityExperienceOrb;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityItem;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EnumMobType;
import net.minecraft.server.Explosion;
import net.minecraft.server.IBlockAccess;
import net.minecraft.server.Item;
import net.minecraft.server.ItemAnvil;
import net.minecraft.server.ItemBlock;
import net.minecraft.server.ItemCloth;
import net.minecraft.server.ItemLeaves;
import net.minecraft.server.ItemMultiTexture;
import net.minecraft.server.ItemPiston;
import net.minecraft.server.ItemSnow;
import net.minecraft.server.ItemStack;
import net.minecraft.server.ItemStep;
import net.minecraft.server.ItemWaterLily;
import net.minecraft.server.ItemWithAuxData;
import net.minecraft.server.LocaleI18n;
import net.minecraft.server.Material;
import net.minecraft.server.MovingObjectPosition;
import net.minecraft.server.StatisticList;
import net.minecraft.server.StepSound;
import net.minecraft.server.StepSoundAnvil;
import net.minecraft.server.StepSoundLadder;
import net.minecraft.server.StepSoundStone;
import net.minecraft.server.TileEntitySign;
import net.minecraft.server.Vec3D;
import net.minecraft.server.World;

public class Block {
    private CreativeModeTab creativeTab;
    protected String f;
    public static final StepSound g = new StepSound("stone", 1.0f, 1.0f);
    public static final StepSound h = new StepSound("wood", 1.0f, 1.0f);
    public static final StepSound i = new StepSound("gravel", 1.0f, 1.0f);
    public static final StepSound j = new StepSound("grass", 1.0f, 1.0f);
    public static final StepSound k = new StepSound("stone", 1.0f, 1.0f);
    public static final StepSound l = new StepSound("stone", 1.0f, 1.5f);
    public static final StepSound m = new StepSoundStone("stone", 1.0f, 1.0f);
    public static final StepSound n = new StepSound("cloth", 1.0f, 1.0f);
    public static final StepSound o = new StepSound("sand", 1.0f, 1.0f);
    public static final StepSound p = new StepSound("snow", 1.0f, 1.0f);
    public static final StepSound q = new StepSoundLadder("ladder", 1.0f, 1.0f);
    public static final StepSound r = new StepSoundAnvil("anvil", 0.3f, 1.0f);
    public static final Block[] byId = new Block[4096];
    public static final boolean[] t = new boolean[4096];
    public static final int[] lightBlock = new int[4096];
    public static final boolean[] v = new boolean[4096];
    public static final int[] lightEmission = new int[4096];
    public static boolean[] x = new boolean[4096];
    public static final Block STONE = new BlockStone(1).c(1.5f).b(10.0f).a(k).c("stone").d("stone");
    public static final BlockGrass GRASS = (BlockGrass)new BlockGrass(2).c(0.6f).a(j).c("grass").d("grass");
    public static final Block DIRT = new BlockDirt(3).c(0.5f).a(i).c("dirt").d("dirt");
    public static final Block COBBLESTONE = new Block(4, Material.STONE).c(2.0f).b(10.0f).a(k).c("stonebrick").a(CreativeModeTab.b).d("cobblestone");
    public static final Block WOOD = new BlockWood(5).c(2.0f).b(5.0f).a(h).c("wood").d("planks");
    public static final Block SAPLING = new BlockSapling(6).c(0.0f).a(j).c("sapling").d("sapling");
    public static final Block BEDROCK = new Block(7, Material.STONE).r().b(6000000.0f).a(k).c("bedrock").C().a(CreativeModeTab.b).d("bedrock");
    public static final BlockFluids WATER = (BlockFluids)new BlockFlowing(8, Material.WATER).c(100.0f).k(3).c("water").C().d("water_flow");
    public static final Block STATIONARY_WATER = new BlockStationary(9, Material.WATER).c(100.0f).k(3).c("water").C().d("water_still");
    public static final BlockFluids LAVA = (BlockFluids)new BlockFlowing(10, Material.LAVA).c(0.0f).a(1.0f).c("lava").C().d("lava_flow");
    public static final Block STATIONARY_LAVA = new BlockStationary(11, Material.LAVA).c(100.0f).a(1.0f).c("lava").C().d("lava_still");
    public static final Block SAND = new BlockSand(12).c(0.5f).a(o).c("sand").d("sand");
    public static final Block GRAVEL = new BlockGravel(13).c(0.6f).a(i).c("gravel").d("gravel");
    public static final Block GOLD_ORE = new BlockOre(14).c(3.0f).b(5.0f).a(k).c("oreGold").d("gold_ore");
    public static final Block IRON_ORE = new BlockOre(15).c(3.0f).b(5.0f).a(k).c("oreIron").d("iron_ore");
    public static final Block COAL_ORE = new BlockOre(16).c(3.0f).b(5.0f).a(k).c("oreCoal").d("coal_ore");
    public static final Block LOG = new BlockLog(17).c(2.0f).a(h).c("log").d("log");
    public static final BlockLeaves LEAVES = (BlockLeaves)new BlockLeaves(18).c(0.2f).k(1).a(j).c("leaves").d("leaves");
    public static final Block SPONGE = new BlockSponge(19).c(0.6f).a(j).c("sponge").d("sponge");
    public static final Block GLASS = new BlockGlass(20, Material.SHATTERABLE, false).c(0.3f).a(m).c("glass").d("glass");
    public static final Block LAPIS_ORE = new BlockOre(21).c(3.0f).b(5.0f).a(k).c("oreLapis").d("lapis_ore");
    public static final Block LAPIS_BLOCK = new Block(22, Material.STONE).c(3.0f).b(5.0f).a(k).c("blockLapis").a(CreativeModeTab.b).d("lapis_block");
    public static final Block DISPENSER = new BlockDispenser(23).c(3.5f).a(k).c("dispenser").d("dispenser");
    public static final Block SANDSTONE = new BlockSandStone(24).a(k).c(0.8f).c("sandStone").d("sandstone");
    public static final Block NOTE_BLOCK = new BlockNote(25).c(0.8f).c("musicBlock").d("noteblock");
    public static final Block BED = new BlockBed(26).c(0.2f).c("bed").C().d("bed");
    public static final Block GOLDEN_RAIL = new BlockPoweredRail(27).c(0.7f).a(l).c("goldenRail").d("rail_golden");
    public static final Block DETECTOR_RAIL = new BlockMinecartDetector(28).c(0.7f).a(l).c("detectorRail").d("rail_detector");
    public static final BlockPiston PISTON_STICKY = (BlockPiston)new BlockPiston(29, true).c("pistonStickyBase");
    public static final Block WEB = new BlockWeb(30).k(1).c(4.0f).c("web").d("web");
    public static final BlockLongGrass LONG_GRASS = (BlockLongGrass)new BlockLongGrass(31).c(0.0f).a(j).c("tallgrass");
    public static final BlockDeadBush DEAD_BUSH = (BlockDeadBush)new BlockDeadBush(32).c(0.0f).a(j).c("deadbush").d("deadbush");
    public static final BlockPiston PISTON = (BlockPiston)new BlockPiston(33, false).c("pistonBase");
    public static final BlockPistonExtension PISTON_EXTENSION = new BlockPistonExtension(34);
    public static final Block WOOL = new BlockCloth(35, Material.CLOTH).c(0.8f).a(n).c("cloth").d("wool_colored");
    public static final BlockPistonMoving PISTON_MOVING = new BlockPistonMoving(36);
    public static final BlockFlower YELLOW_FLOWER = (BlockFlower)new BlockFlower(37).c(0.0f).a(j).c("flower").d("flower_dandelion");
    public static final BlockFlower RED_ROSE = (BlockFlower)new BlockFlower(38).c(0.0f).a(j).c("rose").d("flower_rose");
    public static final BlockFlower BROWN_MUSHROOM = (BlockFlower)new BlockMushroom(39).c(0.0f).a(j).a(0.125f).c("mushroom").d("mushroom_brown");
    public static final BlockFlower RED_MUSHROOM = (BlockFlower)new BlockMushroom(40).c(0.0f).a(j).c("mushroom").d("mushroom_red");
    public static final Block GOLD_BLOCK = new BlockOreBlock(41).c(3.0f).b(10.0f).a(l).c("blockGold").d("gold_block");
    public static final Block IRON_BLOCK = new BlockOreBlock(42).c(5.0f).b(10.0f).a(l).c("blockIron").d("iron_block");
    public static final BlockStepAbstract DOUBLE_STEP = (BlockStepAbstract)new BlockStep(43, true).c(2.0f).b(10.0f).a(k).c("stoneSlab");
    public static final BlockStepAbstract STEP = (BlockStepAbstract)new BlockStep(44, false).c(2.0f).b(10.0f).a(k).c("stoneSlab");
    public static final Block BRICK = new Block(45, Material.STONE).c(2.0f).b(10.0f).a(k).c("brick").a(CreativeModeTab.b).d("brick");
    public static final Block TNT = new BlockTNT(46).c(0.0f).a(j).c("tnt").d("tnt");
    public static final Block BOOKSHELF = new BlockBookshelf(47).c(1.5f).a(h).c("bookshelf").d("bookshelf");
    public static final Block MOSSY_COBBLESTONE = new Block(48, Material.STONE).c(2.0f).b(10.0f).a(k).c("stoneMoss").a(CreativeModeTab.b).d("cobblestone_mossy");
    public static final Block OBSIDIAN = new BlockObsidian(49).c(50.0f).b(2000.0f).a(k).c("obsidian").d("obsidian");
    public static final Block TORCH = new BlockTorch(50).c(0.0f).a(0.9375f).a(h).c("torch").d("torch_on");
    public static final BlockFire FIRE = (BlockFire)new BlockFire(51).c(0.0f).a(1.0f).a(h).c("fire").C().d("fire");
    public static final Block MOB_SPAWNER = new BlockMobSpawner(52).c(5.0f).a(l).c("mobSpawner").C().d("mob_spawner");
    public static final Block WOOD_STAIRS = new BlockStairs(53, WOOD, 0).c("stairsWood");
    public static final BlockChest CHEST = (BlockChest)new BlockChest(54, 0).c(2.5f).a(h).c("chest");
    public static final BlockRedstoneWire REDSTONE_WIRE = (BlockRedstoneWire)new BlockRedstoneWire(55).c(0.0f).a(g).c("redstoneDust").C().d("redstone_dust");
    public static final Block DIAMOND_ORE = new BlockOre(56).c(3.0f).b(5.0f).a(k).c("oreDiamond").d("diamond_ore");
    public static final Block DIAMOND_BLOCK = new BlockOreBlock(57).c(5.0f).b(10.0f).a(l).c("blockDiamond").d("diamond_block");
    public static final Block WORKBENCH = new BlockWorkbench(58).c(2.5f).a(h).c("workbench").d("crafting_table");
    public static final Block CROPS = new BlockCrops(59).c("crops").d("wheat");
    public static final Block SOIL = new BlockSoil(60).c(0.6f).a(i).c("farmland").d("farmland");
    public static final Block FURNACE = new BlockFurnace(61, false).c(3.5f).a(k).c("furnace").a(CreativeModeTab.c);
    public static final Block BURNING_FURNACE = new BlockFurnace(62, true).c(3.5f).a(k).a(0.875f).c("furnace");
    public static final Block SIGN_POST = new BlockSign(63, TileEntitySign.class, true).c(1.0f).a(h).c("sign").C();
    public static final Block WOODEN_DOOR = new BlockDoor(64, Material.WOOD).c(3.0f).a(h).c("doorWood").C().d("door_wood");
    public static final Block LADDER = new BlockLadder(65).c(0.4f).a(q).c("ladder").d("ladder");
    public static final Block RAILS = new BlockMinecartTrack(66).c(0.7f).a(l).c("rail").d("rail_normal");
    public static final Block COBBLESTONE_STAIRS = new BlockStairs(67, COBBLESTONE, 0).c("stairsStone");
    public static final Block WALL_SIGN = new BlockSign(68, TileEntitySign.class, false).c(1.0f).a(h).c("sign").C();
    public static final Block LEVER = new BlockLever(69).c(0.5f).a(h).c("lever").d("lever");
    public static final Block STONE_PLATE = new BlockPressurePlateBinary(70, "stone", Material.STONE, EnumMobType.MOBS).c(0.5f).a(k).c("pressurePlate");
    public static final Block IRON_DOOR_BLOCK = new BlockDoor(71, Material.ORE).c(5.0f).a(l).c("doorIron").C().d("door_iron");
    public static final Block WOOD_PLATE = new BlockPressurePlateBinary(72, "planks_oak", Material.WOOD, EnumMobType.EVERYTHING).c(0.5f).a(h).c("pressurePlate");
    public static final Block REDSTONE_ORE = new BlockRedstoneOre(73, false).c(3.0f).b(5.0f).a(k).c("oreRedstone").a(CreativeModeTab.b).d("redstone_ore");
    public static final Block GLOWING_REDSTONE_ORE = new BlockRedstoneOre(74, true).a(0.625f).c(3.0f).b(5.0f).a(k).c("oreRedstone").d("redstone_ore");
    public static final Block REDSTONE_TORCH_OFF = new BlockRedstoneTorch(75, false).c(0.0f).a(h).c("notGate").d("redstone_torch_off");
    public static final Block REDSTONE_TORCH_ON = new BlockRedstoneTorch(76, true).c(0.0f).a(0.5f).a(h).c("notGate").a(CreativeModeTab.d).d("redstone_torch_on");
    public static final Block STONE_BUTTON = new BlockStoneButton(77).c(0.5f).a(k).c("button");
    public static final Block SNOW = new BlockSnow(78).c(0.1f).a(p).c("snow").k(0).d("snow");
    public static final Block ICE = new BlockIce(79).c(0.5f).k(3).a(m).c("ice").d("ice");
    public static final Block SNOW_BLOCK = new BlockSnowBlock(80).c(0.2f).a(p).c("snow").d("snow");
    public static final Block CACTUS = new BlockCactus(81).c(0.4f).a(n).c("cactus").d("cactus");
    public static final Block CLAY = new BlockClay(82).c(0.6f).a(i).c("clay").d("clay");
    public static final Block SUGAR_CANE_BLOCK = new BlockReed(83).c(0.0f).a(j).c("reeds").C().d("reeds");
    public static final Block JUKEBOX = new BlockJukeBox(84).c(2.0f).b(10.0f).a(k).c("jukebox").d("jukebox");
    public static final Block FENCE = new BlockFence(85, "planks_oak", Material.WOOD).c(2.0f).b(5.0f).a(h).c("fence");
    public static final Block PUMPKIN = new BlockPumpkin(86, false).c(1.0f).a(h).c("pumpkin").d("pumpkin");
    public static final Block NETHERRACK = new BlockBloodStone(87).c(0.4f).a(k).c("hellrock").d("netherrack");
    public static final Block SOUL_SAND = new BlockSlowSand(88).c(0.5f).a(o).c("hellsand").d("soul_sand");
    public static final Block GLOWSTONE = new BlockLightStone(89, Material.SHATTERABLE).c(0.3f).a(m).a(1.0f).c("lightgem").d("glowstone");
    public static final BlockPortal PORTAL = (BlockPortal)new BlockPortal(90).c(-1.0f).a(m).a(0.75f).c("portal").d("portal");
    public static final Block JACK_O_LANTERN = new BlockPumpkin(91, true).c(1.0f).a(h).a(1.0f).c("litpumpkin").d("pumpkin");
    public static final Block CAKE_BLOCK = new BlockCake(92).c(0.5f).a(n).c("cake").C().d("cake");
    public static final BlockRepeater DIODE_OFF = (BlockRepeater)new BlockRepeater(93, false).c(0.0f).a(h).c("diode").C().d("repeater_off");
    public static final BlockRepeater DIODE_ON = (BlockRepeater)new BlockRepeater(94, true).c(0.0f).a(0.625f).a(h).c("diode").C().d("repeater_on");
    public static final Block LOCKED_CHEST = new BlockLockedChest(95).c(0.0f).a(1.0f).a(h).c("lockedchest").b(true);
    public static final Block TRAP_DOOR = new BlockTrapdoor(96, Material.WOOD).c(3.0f).a(h).c("trapdoor").C().d("trapdoor");
    public static final Block MONSTER_EGGS = new BlockMonsterEggs(97).c(0.75f).c("monsterStoneEgg");
    public static final Block SMOOTH_BRICK = new BlockSmoothBrick(98).c(1.5f).b(10.0f).a(k).c("stonebricksmooth").d("stonebrick");
    public static final Block BIG_MUSHROOM_1 = new BlockHugeMushroom(99, Material.WOOD, 0).c(0.2f).a(h).c("mushroom").d("mushroom_block");
    public static final Block BIG_MUSHROOM_2 = new BlockHugeMushroom(100, Material.WOOD, 1).c(0.2f).a(h).c("mushroom").d("mushroom_block");
    public static final Block IRON_FENCE = new BlockThinFence(101, "iron_bars", "iron_bars", Material.ORE, true).c(5.0f).b(10.0f).a(l).c("fenceIron");
    public static final Block THIN_GLASS = new BlockThinFence(102, "glass", "glass_pane_top", Material.SHATTERABLE, false).c(0.3f).a(m).c("thinGlass");
    public static final Block MELON = new BlockMelon(103).c(1.0f).a(h).c("melon").d("melon");
    public static final Block PUMPKIN_STEM = new BlockStem(104, PUMPKIN).c(0.0f).a(h).c("pumpkinStem").d("pumpkin_stem");
    public static final Block MELON_STEM = new BlockStem(105, MELON).c(0.0f).a(h).c("pumpkinStem").d("melon_stem");
    public static final Block VINE = new BlockVine(106).c(0.2f).a(j).c("vine").d("vine");
    public static final Block FENCE_GATE = new BlockFenceGate(107).c(2.0f).b(5.0f).a(h).c("fenceGate");
    public static final Block BRICK_STAIRS = new BlockStairs(108, BRICK, 0).c("stairsBrick");
    public static final Block STONE_STAIRS = new BlockStairs(109, SMOOTH_BRICK, 0).c("stairsStoneBrickSmooth");
    public static final BlockMycel MYCEL = (BlockMycel)new BlockMycel(110).c(0.6f).a(j).c("mycel").d("mycelium");
    public static final Block WATER_LILY = new BlockWaterLily(111).c(0.0f).a(j).c("waterlily").d("waterlily");
    public static final Block NETHER_BRICK = new Block(112, Material.STONE).c(2.0f).b(10.0f).a(k).c("netherBrick").a(CreativeModeTab.b).d("nether_brick");
    public static final Block NETHER_FENCE = new BlockFence(113, "nether_brick", Material.STONE).c(2.0f).b(10.0f).a(k).c("netherFence");
    public static final Block NETHER_BRICK_STAIRS = new BlockStairs(114, NETHER_BRICK, 0).c("stairsNetherBrick");
    public static final Block NETHER_WART = new BlockNetherWart(115).c("netherStalk").d("nether_wart");
    public static final Block ENCHANTMENT_TABLE = new BlockEnchantmentTable(116).c(5.0f).b(2000.0f).c("enchantmentTable").d("enchanting_table");
    public static final Block BREWING_STAND = new BlockBrewingStand(117).c(0.5f).a(0.125f).c("brewingStand").d("brewing_stand");
    public static final BlockCauldron CAULDRON = (BlockCauldron)new BlockCauldron(118).c(2.0f).c("cauldron").d("cauldron");
    public static final Block ENDER_PORTAL = new BlockEnderPortal(119, Material.PORTAL).c(-1.0f).b(6000000.0f);
    public static final Block ENDER_PORTAL_FRAME = new BlockEnderPortalFrame(120).a(m).a(0.125f).c(-1.0f).c("endPortalFrame").b(6000000.0f).a(CreativeModeTab.c).d("endframe");
    public static final Block WHITESTONE = new Block(121, Material.STONE).c(3.0f).b(15.0f).a(k).c("whiteStone").a(CreativeModeTab.b).d("end_stone");
    public static final Block DRAGON_EGG = new BlockDragonEgg(122).c(3.0f).b(15.0f).a(k).a(0.125f).c("dragonEgg").d("dragon_egg");
    public static final Block REDSTONE_LAMP_OFF = new BlockRedstoneLamp(123, false).c(0.3f).a(m).c("redstoneLight").a(CreativeModeTab.d).d("redstone_lamp_off");
    public static final Block REDSTONE_LAMP_ON = new BlockRedstoneLamp(124, true).c(0.3f).a(m).c("redstoneLight").d("redstone_lamp_on");
    public static final BlockStepAbstract WOOD_DOUBLE_STEP = (BlockStepAbstract)new BlockWoodStep(125, true).c(2.0f).b(5.0f).a(h).c("woodSlab");
    public static final BlockStepAbstract WOOD_STEP = (BlockStepAbstract)new BlockWoodStep(126, false).c(2.0f).b(5.0f).a(h).c("woodSlab");
    public static final Block COCOA = new BlockCocoa(127).c(0.2f).b(5.0f).a(h).c("cocoa").d("cocoa");
    public static final Block SANDSTONE_STAIRS = new BlockStairs(128, SANDSTONE, 0).c("stairsSandStone");
    public static final Block EMERALD_ORE = new BlockOre(129).c(3.0f).b(5.0f).a(k).c("oreEmerald").d("emerald_ore");
    public static final Block ENDER_CHEST = new BlockEnderChest(130).c(22.5f).b(1000.0f).a(k).c("enderChest").a(0.5f);
    public static final BlockTripwireHook TRIPWIRE_SOURCE = (BlockTripwireHook)new BlockTripwireHook(131).c("tripWireSource").d("trip_wire_source");
    public static final Block TRIPWIRE = new BlockTripwire(132).c("tripWire").d("trip_wire");
    public static final Block EMERALD_BLOCK = new BlockOreBlock(133).c(5.0f).b(10.0f).a(l).c("blockEmerald").d("emerald_block");
    public static final Block SPRUCE_WOOD_STAIRS = new BlockStairs(134, WOOD, 1).c("stairsWoodSpruce");
    public static final Block BIRCH_WOOD_STAIRS = new BlockStairs(135, WOOD, 2).c("stairsWoodBirch");
    public static final Block JUNGLE_WOOD_STAIRS = new BlockStairs(136, WOOD, 3).c("stairsWoodJungle");
    public static final Block COMMAND = new BlockCommand(137).r().b(6000000.0f).c("commandBlock").d("command_block");
    public static final BlockBeacon BEACON = (BlockBeacon)new BlockBeacon(138).c("beacon").a(1.0f).d("beacon");
    public static final Block COBBLE_WALL = new BlockCobbleWall(139, COBBLESTONE).c("cobbleWall");
    public static final Block FLOWER_POT = new BlockFlowerPot(140).c(0.0f).a(g).c("flowerPot").d("flower_pot");
    public static final Block CARROTS = new BlockCarrots(141).c("carrots").d("carrots");
    public static final Block POTATOES = new BlockPotatoes(142).c("potatoes").d("potatoes");
    public static final Block WOOD_BUTTON = new BlockWoodButton(143).c(0.5f).a(h).c("button");
    public static final Block SKULL = new BlockSkull(144).c(1.0f).a(k).c("skull").d("skull");
    public static final Block ANVIL = new BlockAnvil(145).c(5.0f).a(r).b(2000.0f).c("anvil");
    public static final Block TRAPPED_CHEST = new BlockChest(146, 1).c(2.5f).a(h).c("chestTrap");
    public static final Block GOLD_PLATE = new BlockPressurePlateWeighted(147, "gold_block", Material.ORE, 64).c(0.5f).a(h).c("weightedPlate_light");
    public static final Block IRON_PLATE = new BlockPressurePlateWeighted(148, "iron_block", Material.ORE, 640).c(0.5f).a(h).c("weightedPlate_heavy");
    public static final BlockRedstoneComparator REDSTONE_COMPARATOR_OFF = (BlockRedstoneComparator)new BlockRedstoneComparator(149, false).c(0.0f).a(h).c("comparator").C().d("comparator_off");
    public static final BlockRedstoneComparator REDSTONE_COMPARATOR_ON = (BlockRedstoneComparator)new BlockRedstoneComparator(150, true).c(0.0f).a(0.625f).a(h).c("comparator").C().d("comparator_on");
    public static final BlockDaylightDetector DAYLIGHT_DETECTOR = (BlockDaylightDetector)new BlockDaylightDetector(151).c(0.2f).a(h).c("daylightDetector").d("daylight_detector");
    public static final Block REDSTONE_BLOCK = new BlockRedstone(152).c(5.0f).b(10.0f).a(l).c("blockRedstone").d("redstone_block");
    public static final Block QUARTZ_ORE = new BlockOre(153).c(3.0f).b(5.0f).a(k).c("netherquartz").d("quartz_ore");
    public static final BlockHopper HOPPER = (BlockHopper)new BlockHopper(154).c(3.0f).b(8.0f).a(h).c("hopper").d("hopper");
    public static final Block QUARTZ_BLOCK = new BlockQuartz(155).a(k).c(0.8f).c("quartzBlock").d("quartz_block");
    public static final Block QUARTZ_STAIRS = new BlockStairs(156, QUARTZ_BLOCK, 0).c("stairsQuartz");
    public static final Block ACTIVATOR_RAIL = new BlockPoweredRail(157).c(0.7f).a(l).c("activatorRail").d("rail_activator");
    public static final Block DROPPER = new BlockDropper(158).c(3.5f).a(k).c("dropper").d("dropper");
    public static final Block STAINED_HARDENED_CLAY = new BlockCloth(159, Material.STONE).c(1.25f).b(7.0f).a(k).c("clayHardenedStained").d("hardened_clay_stained");
    public static final Block HAY_BLOCK = new BlockHay(170).c(0.5f).a(j).c("hayBlock").a(CreativeModeTab.b).d("hay_block");
    public static final Block WOOL_CARPET = new BlockCarpet(171).c(0.1f).a(n).c("woolCarpet").k(0);
    public static final Block HARDENED_CLAY = new Block(172, Material.STONE).c(1.25f).b(7.0f).a(k).c("clayHardened").a(CreativeModeTab.b).d("hardened_clay");
    public static final Block COAL_BLOCK = new Block(173, Material.STONE).c(5.0f).b(10.0f).a(k).c("blockCoal").a(CreativeModeTab.b).d("coal_block");
    public final int id;
    protected float strength;
    protected float durability;
    protected boolean cI = true;
    protected boolean cJ = true;
    protected boolean cK;
    protected boolean isTileEntity;
    protected double minX;
    protected double minY;
    protected double minZ;
    protected double maxX;
    protected double maxY;
    protected double maxZ;
    public StepSound stepSound = g;
    public float cT = 1.0f;
    public final Material material;
    public float frictionFactor = 0.6f;
    private String name;

    protected Block(int n, Material material) {
        if (byId[n] != null) {
            throw new IllegalArgumentException("Slot " + n + " is already occupied by " + byId[n] + " when adding " + this);
        }
        this.material = material;
        Block.byId[n] = this;
        this.id = n;
        this.a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        Block.t[n] = this.c();
        Block.lightBlock[n] = this.c() ? 255 : 0;
        Block.v[n] = !material.blocksLight();
    }

    protected void s_() {
    }

    protected Block a(StepSound stepSound) {
        this.stepSound = stepSound;
        return this;
    }

    protected Block k(int n) {
        Block.lightBlock[this.id] = n;
        return this;
    }

    protected Block a(float f) {
        Block.lightEmission[this.id] = (int)(15.0f * f);
        return this;
    }

    protected Block b(float f) {
        this.durability = f * 3.0f;
        return this;
    }

    public static boolean l(int n) {
        Block block = byId[n];
        if (block == null) {
            return false;
        }
        return block.material.k() && block.b() && !block.isPowerSource();
    }

    public boolean b() {
        return true;
    }

    public boolean b(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        return !this.material.isSolid();
    }

    public int d() {
        return 0;
    }

    protected Block c(float f) {
        this.strength = f;
        if (this.durability < f * 5.0f) {
            this.durability = f * 5.0f;
        }
        return this;
    }

    protected Block r() {
        this.c(-1.0f);
        return this;
    }

    public float l(World world, int n, int n2, int n3) {
        return this.strength;
    }

    protected Block b(boolean bl) {
        this.cK = bl;
        return this;
    }

    public boolean isTicking() {
        return this.cK;
    }

    public boolean t() {
        return this.isTileEntity;
    }

    protected final void a(float f, float f2, float f3, float f4, float f5, float f6) {
        this.minX = f;
        this.minY = f2;
        this.minZ = f3;
        this.maxX = f4;
        this.maxY = f5;
        this.maxZ = f6;
    }

    public boolean a_(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        return iBlockAccess.getMaterial(n, n2, n3).isBuildable();
    }

    public void a(World world, int n, int n2, int n3, AxisAlignedBB axisAlignedBB, List list, Entity entity) {
        AxisAlignedBB axisAlignedBB2 = this.b(world, n, n2, n3);
        if (axisAlignedBB2 != null && axisAlignedBB.b(axisAlignedBB2)) {
            list.add(axisAlignedBB2);
        }
    }

    public AxisAlignedBB b(World world, int n, int n2, int n3) {
        return AxisAlignedBB.a().a((double)n + this.minX, (double)n2 + this.minY, (double)n3 + this.minZ, (double)n + this.maxX, (double)n2 + this.maxY, (double)n3 + this.maxZ);
    }

    public boolean c() {
        return true;
    }

    public boolean a(int n, boolean bl) {
        return this.m();
    }

    public boolean m() {
        return true;
    }

    public void a(World world, int n, int n2, int n3, Random random) {
    }

    public void postBreak(World world, int n, int n2, int n3, int n4) {
    }

    public void doPhysics(World world, int n, int n2, int n3, int n4) {
    }

    public int a(World world) {
        return 10;
    }

    public void onPlace(World world, int n, int n2, int n3) {
    }

    public void remove(World world, int n, int n2, int n3, int n4, int n5) {
    }

    public int a(Random random) {
        return 1;
    }

    public int getDropType(int n, Random random, int n2) {
        return this.id;
    }

    public float getDamage(EntityHuman entityHuman, World world, int n, int n2, int n3) {
        float f = this.l(world, n, n2, n3);
        if (f < 0.0f) {
            return 0.0f;
        }
        if (!entityHuman.a(this)) {
            return entityHuman.a(this, false) / f / 100.0f;
        }
        return entityHuman.a(this, true) / f / 30.0f;
    }

    public final void c(World world, int n, int n2, int n3, int n4, int n5) {
        this.dropNaturally(world, n, n2, n3, n4, 1.0f, n5);
    }

    public void dropNaturally(World world, int n, int n2, int n3, int n4, float f, int n5) {
        if (world.isStatic) {
            return;
        }
        int n6 = this.getDropCount(n5, world.random);
        for (int i = 0; i < n6; ++i) {
            int n7;
            if (world.random.nextFloat() > f || (n7 = this.getDropType(n4, world.random, n5)) <= 0) continue;
            this.b(world, n, n2, n3, new ItemStack(n7, 1, this.getDropData(n4)));
        }
    }

    protected void b(World world, int n, int n2, int n3, ItemStack itemStack) {
        if (world.isStatic || !world.getGameRules().getBoolean("doTileDrops")) {
            return;
        }
        float f = 0.7f;
        double d = (double)(world.random.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d2 = (double)(world.random.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d3 = (double)(world.random.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        EntityItem entityItem = new EntityItem(world, (double)n + d, (double)n2 + d2, (double)n3 + d3, itemStack);
        entityItem.pickupDelay = 10;
        world.addEntity(entityItem);
    }

    protected void j(World world, int n, int n2, int n3, int n4) {
        if (!world.isStatic) {
            while (n4 > 0) {
                int n5 = EntityExperienceOrb.getOrbValue(n4);
                n4 -= n5;
                world.addEntity(new EntityExperienceOrb(world, (double)n + 0.5, (double)n2 + 0.5, (double)n3 + 0.5, n5));
            }
        }
    }

    public int getDropData(int n) {
        return 0;
    }

    public float a(Entity entity) {
        return this.durability / 5.0f;
    }

    public MovingObjectPosition a(World world, int n, int n2, int n3, Vec3D vec3D, Vec3D vec3D2) {
        this.updateShape(world, n, n2, n3);
        vec3D = vec3D.add(-n, -n2, -n3);
        vec3D2 = vec3D2.add(-n, -n2, -n3);
        Vec3D vec3D3 = vec3D.b(vec3D2, this.minX);
        Vec3D vec3D4 = vec3D.b(vec3D2, this.maxX);
        Vec3D vec3D5 = vec3D.c(vec3D2, this.minY);
        Vec3D vec3D6 = vec3D.c(vec3D2, this.maxY);
        Vec3D vec3D7 = vec3D.d(vec3D2, this.minZ);
        Vec3D vec3D8 = vec3D.d(vec3D2, this.maxZ);
        if (!this.a(vec3D3)) {
            vec3D3 = null;
        }
        if (!this.a(vec3D4)) {
            vec3D4 = null;
        }
        if (!this.b(vec3D5)) {
            vec3D5 = null;
        }
        if (!this.b(vec3D6)) {
            vec3D6 = null;
        }
        if (!this.c(vec3D7)) {
            vec3D7 = null;
        }
        if (!this.c(vec3D8)) {
            vec3D8 = null;
        }
        Vec3D vec3D9 = null;
        if (vec3D3 != null && (vec3D9 == null || vec3D.distanceSquared(vec3D3) < vec3D.distanceSquared(vec3D9))) {
            vec3D9 = vec3D3;
        }
        if (vec3D4 != null && (vec3D9 == null || vec3D.distanceSquared(vec3D4) < vec3D.distanceSquared(vec3D9))) {
            vec3D9 = vec3D4;
        }
        if (vec3D5 != null && (vec3D9 == null || vec3D.distanceSquared(vec3D5) < vec3D.distanceSquared(vec3D9))) {
            vec3D9 = vec3D5;
        }
        if (vec3D6 != null && (vec3D9 == null || vec3D.distanceSquared(vec3D6) < vec3D.distanceSquared(vec3D9))) {
            vec3D9 = vec3D6;
        }
        if (vec3D7 != null && (vec3D9 == null || vec3D.distanceSquared(vec3D7) < vec3D.distanceSquared(vec3D9))) {
            vec3D9 = vec3D7;
        }
        if (vec3D8 != null && (vec3D9 == null || vec3D.distanceSquared(vec3D8) < vec3D.distanceSquared(vec3D9))) {
            vec3D9 = vec3D8;
        }
        if (vec3D9 == null) {
            return null;
        }
        int n4 = -1;
        if (vec3D9 == vec3D3) {
            n4 = 4;
        }
        if (vec3D9 == vec3D4) {
            n4 = 5;
        }
        if (vec3D9 == vec3D5) {
            n4 = 0;
        }
        if (vec3D9 == vec3D6) {
            n4 = 1;
        }
        if (vec3D9 == vec3D7) {
            n4 = 2;
        }
        if (vec3D9 == vec3D8) {
            n4 = 3;
        }
        return new MovingObjectPosition(n, n2, n3, n4, vec3D9.add(n, n2, n3));
    }

    private boolean a(Vec3D vec3D) {
        if (vec3D == null) {
            return false;
        }
        return vec3D.d >= this.minY && vec3D.d <= this.maxY && vec3D.e >= this.minZ && vec3D.e <= this.maxZ;
    }

    private boolean b(Vec3D vec3D) {
        if (vec3D == null) {
            return false;
        }
        return vec3D.c >= this.minX && vec3D.c <= this.maxX && vec3D.e >= this.minZ && vec3D.e <= this.maxZ;
    }

    private boolean c(Vec3D vec3D) {
        if (vec3D == null) {
            return false;
        }
        return vec3D.c >= this.minX && vec3D.c <= this.maxX && vec3D.d >= this.minY && vec3D.d <= this.maxY;
    }

    public void wasExploded(World world, int n, int n2, int n3, Explosion explosion) {
    }

    public boolean canPlace(World world, int n, int n2, int n3, int n4, ItemStack itemStack) {
        return this.canPlace(world, n, n2, n3, n4);
    }

    public boolean canPlace(World world, int n, int n2, int n3, int n4) {
        return this.canPlace(world, n, n2, n3);
    }

    public boolean canPlace(World world, int n, int n2, int n3) {
        int n4 = world.getTypeId(n, n2, n3);
        return n4 == 0 || Block.byId[n4].material.isReplaceable();
    }

    public boolean interact(World world, int n, int n2, int n3, EntityHuman entityHuman, int n4, float f, float f2, float f3) {
        return false;
    }

    public void b(World world, int n, int n2, int n3, Entity entity) {
    }

    public int getPlacedData(World world, int n, int n2, int n3, int n4, float f, float f2, float f3, int n5) {
        return n5;
    }

    public void attack(World world, int n, int n2, int n3, EntityHuman entityHuman) {
    }

    public void a(World world, int n, int n2, int n3, Entity entity, Vec3D vec3D) {
    }

    public void updateShape(IBlockAccess iBlockAccess, int n, int n2, int n3) {
    }

    public final double u() {
        return this.minX;
    }

    public final double v() {
        return this.maxX;
    }

    public final double w() {
        return this.minY;
    }

    public final double x() {
        return this.maxY;
    }

    public final double y() {
        return this.minZ;
    }

    public final double z() {
        return this.maxZ;
    }

    public int b(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        return 0;
    }

    public boolean isPowerSource() {
        return false;
    }

    public void a(World world, int n, int n2, int n3, Entity entity) {
    }

    public int c(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        return 0;
    }

    public void g() {
    }

    public void a(World world, EntityHuman entityHuman, int n, int n2, int n3, int n4) {
        entityHuman.a(StatisticList.C[this.id], 1);
        entityHuman.a(0.025f);
        if (this.r_() && EnchantmentManager.hasSilkTouchEnchantment(entityHuman)) {
            ItemStack itemStack = this.d_(n4);
            if (itemStack != null) {
                this.b(world, n, n2, n3, itemStack);
            }
        } else {
            int n5 = EnchantmentManager.getBonusBlockLootEnchantmentLevel(entityHuman);
            this.c(world, n, n2, n3, n4, n5);
        }
    }

    protected boolean r_() {
        return this.b() && !this.isTileEntity;
    }

    protected ItemStack d_(int n) {
        int n2 = 0;
        if (this.id >= 0 && this.id < Item.byId.length && Item.byId[this.id].n()) {
            n2 = n;
        }
        return new ItemStack(this.id, 1, n2);
    }

    public int getDropCount(int n, Random random) {
        return this.a(random);
    }

    public boolean f(World world, int n, int n2, int n3) {
        return true;
    }

    public void postPlace(World world, int n, int n2, int n3, EntityLiving entityLiving, ItemStack itemStack) {
    }

    public void postPlace(World world, int n, int n2, int n3, int n4) {
    }

    public Block c(String string) {
        this.name = string;
        return this;
    }

    public String getName() {
        return LocaleI18n.get(this.a() + ".name");
    }

    public String a() {
        return "tile." + this.name;
    }

    public boolean b(World world, int n, int n2, int n3, int n4, int n5) {
        return false;
    }

    public boolean B() {
        return this.cJ;
    }

    protected Block C() {
        this.cJ = false;
        return this;
    }

    public int h() {
        return this.material.getPushReaction();
    }

    public void a(World world, int n, int n2, int n3, Entity entity, float f) {
    }

    public int getDropData(World world, int n, int n2, int n3) {
        return this.getDropData(world.getData(n, n2, n3));
    }

    public Block a(CreativeModeTab creativeModeTab) {
        this.creativeTab = creativeModeTab;
        return this;
    }

    public void a(World world, int n, int n2, int n3, int n4, EntityHuman entityHuman) {
    }

    public void l(World world, int n, int n2, int n3, int n4) {
    }

    public void g(World world, int n, int n2, int n3) {
    }

    public boolean l() {
        return true;
    }

    public boolean a(Explosion explosion) {
        return true;
    }

    public boolean i(int n) {
        return this.id == n;
    }

    public static boolean b(int n, int n2) {
        if (n == n2) {
            return true;
        }
        if (n == 0 || n2 == 0 || byId[n] == null || byId[n2] == null) {
            return false;
        }
        return byId[n].i(n2);
    }

    public boolean q_() {
        return false;
    }

    public int b_(World world, int n, int n2, int n3, int n4) {
        return 0;
    }

    protected Block d(String string) {
        this.f = string;
        return this;
    }

    static {
        Item.byId[Block.WOOL.id] = new ItemCloth(Block.WOOL.id - 256).b("cloth");
        Item.byId[Block.STAINED_HARDENED_CLAY.id] = new ItemCloth(Block.STAINED_HARDENED_CLAY.id - 256).b("clayHardenedStained");
        Item.byId[Block.WOOL_CARPET.id] = new ItemCloth(Block.WOOL_CARPET.id - 256).b("woolCarpet");
        Item.byId[Block.LOG.id] = new ItemMultiTexture(Block.LOG.id - 256, LOG, BlockLog.b).b("log");
        Item.byId[Block.WOOD.id] = new ItemMultiTexture(Block.WOOD.id - 256, WOOD, BlockWood.a).b("wood");
        Item.byId[Block.MONSTER_EGGS.id] = new ItemMultiTexture(Block.MONSTER_EGGS.id - 256, MONSTER_EGGS, BlockMonsterEggs.a).b("monsterStoneEgg");
        Item.byId[Block.SMOOTH_BRICK.id] = new ItemMultiTexture(Block.SMOOTH_BRICK.id - 256, SMOOTH_BRICK, BlockSmoothBrick.a).b("stonebricksmooth");
        Item.byId[Block.SANDSTONE.id] = new ItemMultiTexture(Block.SANDSTONE.id - 256, SANDSTONE, BlockSandStone.a).b("sandStone");
        Item.byId[Block.QUARTZ_BLOCK.id] = new ItemMultiTexture(Block.QUARTZ_BLOCK.id - 256, QUARTZ_BLOCK, BlockQuartz.a).b("quartzBlock");
        Item.byId[Block.STEP.id] = new ItemStep(Block.STEP.id - 256, STEP, DOUBLE_STEP, false).b("stoneSlab");
        Item.byId[Block.DOUBLE_STEP.id] = new ItemStep(Block.DOUBLE_STEP.id - 256, STEP, DOUBLE_STEP, true).b("stoneSlab");
        Item.byId[Block.WOOD_STEP.id] = new ItemStep(Block.WOOD_STEP.id - 256, WOOD_STEP, WOOD_DOUBLE_STEP, false).b("woodSlab");
        Item.byId[Block.WOOD_DOUBLE_STEP.id] = new ItemStep(Block.WOOD_DOUBLE_STEP.id - 256, WOOD_STEP, WOOD_DOUBLE_STEP, true).b("woodSlab");
        Item.byId[Block.SAPLING.id] = new ItemMultiTexture(Block.SAPLING.id - 256, SAPLING, BlockSapling.a).b("sapling");
        Item.byId[Block.LEAVES.id] = new ItemLeaves(Block.LEAVES.id - 256).b("leaves");
        Item.byId[Block.VINE.id] = new ItemWithAuxData(Block.VINE.id - 256, false);
        Item.byId[Block.LONG_GRASS.id] = new ItemWithAuxData(Block.LONG_GRASS.id - 256, true).a(new String[]{"shrub", "grass", "fern"});
        Item.byId[Block.SNOW.id] = new ItemSnow(Block.SNOW.id - 256, SNOW);
        Item.byId[Block.WATER_LILY.id] = new ItemWaterLily(Block.WATER_LILY.id - 256);
        Item.byId[Block.PISTON.id] = new ItemPiston(Block.PISTON.id - 256);
        Item.byId[Block.PISTON_STICKY.id] = new ItemPiston(Block.PISTON_STICKY.id - 256);
        Item.byId[Block.COBBLE_WALL.id] = new ItemMultiTexture(Block.COBBLE_WALL.id - 256, COBBLE_WALL, BlockCobbleWall.a).b("cobbleWall");
        Item.byId[Block.ANVIL.id] = new ItemAnvil(ANVIL).b("anvil");
        for (int i = 0; i < 256; ++i) {
            if (byId[i] == null) continue;
            if (Item.byId[i] == null) {
                Item.byId[i] = new ItemBlock(i - 256);
                byId[i].s_();
            }
            boolean bl = false;
            if (i > 0 && byId[i].d() == 10) {
                bl = true;
            }
            if (i > 0 && byId[i] instanceof BlockStepAbstract) {
                bl = true;
            }
            if (i == Block.SOIL.id) {
                bl = true;
            }
            if (v[i]) {
                bl = true;
            }
            if (lightBlock[i] == 0) {
                bl = true;
            }
            Block.x[i] = bl;
        }
        Block.v[0] = true;
        StatisticList.b();
    }
}

