/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.server.BanEntry;
import net.minecraft.server.InsensitiveStringMap;
import net.minecraft.server.MinecraftServer;

public class BanList {
    private final InsensitiveStringMap a = new InsensitiveStringMap();
    private final File b;
    private boolean c = true;

    public BanList(File file) {
        this.b = file;
    }

    public boolean isEnabled() {
        return this.c;
    }

    public void setEnabled(boolean bl) {
        this.c = bl;
    }

    public Map getEntries() {
        this.removeExpired();
        return this.a;
    }

    public boolean isBanned(String string) {
        if (!this.isEnabled()) {
            return false;
        }
        this.removeExpired();
        return this.a.containsKey(string);
    }

    public void add(BanEntry banEntry) {
        this.a.put(banEntry.getName(), (Object)banEntry);
        this.save();
    }

    public void remove(String string) {
        this.a.remove(string);
        this.save();
    }

    public void removeExpired() {
        Iterator iterator = this.a.values().iterator();
        while (iterator.hasNext()) {
            BanEntry banEntry = (BanEntry)iterator.next();
            if (!banEntry.hasExpired()) continue;
            iterator.remove();
        }
    }

    public void load() {
        BufferedReader bufferedReader;
        if (!this.b.isFile()) {
            return;
        }
        try {
            bufferedReader = new BufferedReader(new FileReader(this.b));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new Error();
        }
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                BanEntry banEntry;
                if (string.startsWith("#") || (banEntry = BanEntry.c(string)) == null) continue;
                this.a.put(banEntry.getName(), (Object)banEntry);
            }
        }
        catch (IOException iOException) {
            MinecraftServer.getServer().getLogger().severe("Could not load ban list", iOException);
        }
    }

    public void save() {
        this.save(true);
    }

    public void save(boolean bl) {
        this.removeExpired();
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(this.b, false));
            if (bl) {
                printWriter.println("# Updated " + new SimpleDateFormat().format(new Date()) + " by Minecraft " + "1.6.4");
                printWriter.println("# victim name | ban date | banned by | banned until | reason");
                printWriter.println();
            }
            for (BanEntry banEntry : this.a.values()) {
                printWriter.println(banEntry.g());
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            MinecraftServer.getServer().getLogger().severe("Could not save ban list", iOException);
        }
    }
}

