/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import net.minecraft.server.MinecraftServer;

public class BanEntry {
    public static final SimpleDateFormat a = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
    private final String b;
    private Date c = new Date();
    private String d = "(Unknown)";
    private Date e;
    private String f = "Banned by an operator.";

    public BanEntry(String string) {
        this.b = string;
    }

    public String getName() {
        return this.b;
    }

    public Date getCreated() {
        return this.c;
    }

    public void setCreated(Date date) {
        this.c = date != null ? date : new Date();
    }

    public String getSource() {
        return this.d;
    }

    public void setSource(String string) {
        this.d = string;
    }

    public Date getExpires() {
        return this.e;
    }

    public void setExpires(Date date) {
        this.e = date;
    }

    public boolean hasExpired() {
        if (this.e == null) {
            return false;
        }
        return this.e.before(new Date());
    }

    public String getReason() {
        return this.f;
    }

    public void setReason(String string) {
        this.f = string;
    }

    public String g() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getName());
        stringBuilder.append("|");
        stringBuilder.append(a.format(this.getCreated()));
        stringBuilder.append("|");
        stringBuilder.append(this.getSource());
        stringBuilder.append("|");
        stringBuilder.append(this.getExpires() == null ? "Forever" : a.format(this.getExpires()));
        stringBuilder.append("|");
        stringBuilder.append(this.getReason());
        return stringBuilder.toString();
    }

    public static BanEntry c(String string) {
        if (string.trim().length() < 2) {
            return null;
        }
        String[] stringArray = string.trim().split(Pattern.quote("|"), 5);
        BanEntry banEntry = new BanEntry(stringArray[0].trim());
        int n = 0;
        if (stringArray.length <= ++n) {
            return banEntry;
        }
        try {
            banEntry.setCreated(a.parse(stringArray[n].trim()));
        }
        catch (ParseException parseException) {
            MinecraftServer.getServer().getLogger().warning("Could not read creation date format for ban entry '" + banEntry.getName() + "' (was: '" + stringArray[n] + "')", parseException);
        }
        if (stringArray.length <= ++n) {
            return banEntry;
        }
        banEntry.setSource(stringArray[n].trim());
        if (stringArray.length <= ++n) {
            return banEntry;
        }
        try {
            String string2 = stringArray[n].trim();
            if (!string2.equalsIgnoreCase("Forever") && string2.length() > 0) {
                banEntry.setExpires(a.parse(string2));
            }
        }
        catch (ParseException parseException) {
            MinecraftServer.getServer().getLogger().warning("Could not read expiry date format for ban entry '" + banEntry.getName() + "' (was: '" + stringArray[n] + "')", parseException);
        }
        if (stringArray.length <= ++n) {
            return banEntry;
        }
        banEntry.setReason(stringArray[n].trim());
        return banEntry;
    }
}

