/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.EnumGamemode;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.WorldSettings;
import net.minecraft.server.WorldType;

public class WorldData {
    private long seed;
    private WorldType type = WorldType.NORMAL;
    private int spawnX;
    private int spawnY;
    private int spawnZ;
    private long time;
    private long lastPlayed;
    private long sizeOnDisk;
    private NBTTagCompound playerData;
    private int dimension;
    private String name;
    private int version;
    private boolean isRaining;
    private int rainTicks;
    private boolean isThundering;
    private int thunderTicks;
    private EnumGamemode gameType;
    private boolean useMapFeatures;
    private boolean hardcore;
    private boolean allowCommands;
    private boolean initialized;

    protected WorldData() {
    }

    public WorldData(NBTTagCompound nBTTagCompound) {
        this.seed = nBTTagCompound.getLong("RandomSeed");
        if (nBTTagCompound.hasKey("generatorName")) {
            String string = nBTTagCompound.getString("generatorName");
            this.type = WorldType.getType(string);
            if (this.type == null) {
                this.type = WorldType.NORMAL;
            } else if (this.type.e()) {
                int n = 0;
                if (nBTTagCompound.hasKey("generatorVersion")) {
                    n = nBTTagCompound.getInt("generatorVersion");
                }
                this.type = this.type.a(n);
            }
        }
        this.gameType = EnumGamemode.a(nBTTagCompound.getInt("GameType"));
        this.useMapFeatures = nBTTagCompound.hasKey("MapFeatures") ? nBTTagCompound.getBoolean("MapFeatures") : true;
        this.spawnX = nBTTagCompound.getInt("SpawnX");
        this.spawnY = nBTTagCompound.getInt("SpawnY");
        this.spawnZ = nBTTagCompound.getInt("SpawnZ");
        this.time = nBTTagCompound.getLong("Time");
        this.lastPlayed = nBTTagCompound.getLong("LastPlayed");
        this.sizeOnDisk = nBTTagCompound.getLong("SizeOnDisk");
        this.name = nBTTagCompound.getString("LevelName");
        this.version = nBTTagCompound.getInt("version");
        this.rainTicks = nBTTagCompound.getInt("rainTime");
        this.isRaining = nBTTagCompound.getBoolean("raining");
        this.thunderTicks = nBTTagCompound.getInt("thunderTime");
        this.isThundering = nBTTagCompound.getBoolean("thundering");
        this.hardcore = nBTTagCompound.getBoolean("hardcore");
        this.initialized = nBTTagCompound.hasKey("initialized") ? nBTTagCompound.getBoolean("initialized") : true;
        if (nBTTagCompound.hasKey("allowCommands")) {
            this.allowCommands = nBTTagCompound.getBoolean("allowCommands");
        } else {
            boolean bl = this.allowCommands = this.gameType == EnumGamemode.CREATIVE;
        }
        if (nBTTagCompound.hasKey("Player")) {
            this.playerData = nBTTagCompound.getCompound("Player");
            this.dimension = this.playerData.getInt("Dimension");
        }
    }

    public WorldData(WorldSettings worldSettings, String string) {
        this.seed = worldSettings.d();
        this.gameType = worldSettings.e();
        this.useMapFeatures = worldSettings.g();
        this.name = string;
        this.hardcore = worldSettings.f();
        this.type = worldSettings.h();
        this.allowCommands = worldSettings.i();
        this.initialized = false;
    }

    public WorldData(WorldData worldData) {
        this.seed = worldData.seed;
        this.type = worldData.type;
        this.gameType = worldData.gameType;
        this.useMapFeatures = worldData.useMapFeatures;
        this.spawnX = worldData.spawnX;
        this.spawnY = worldData.spawnY;
        this.spawnZ = worldData.spawnZ;
        this.time = worldData.time;
        this.lastPlayed = worldData.lastPlayed;
        this.sizeOnDisk = worldData.sizeOnDisk;
        this.playerData = worldData.playerData;
        this.dimension = worldData.dimension;
        this.name = worldData.name;
        this.version = worldData.version;
        this.rainTicks = worldData.rainTicks;
        this.isRaining = worldData.isRaining;
        this.thunderTicks = worldData.thunderTicks;
        this.isThundering = worldData.isThundering;
        this.hardcore = worldData.hardcore;
        this.allowCommands = worldData.allowCommands;
        this.initialized = worldData.initialized;
    }

    public NBTTagCompound a() {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        this.a(nBTTagCompound, this.playerData);
        return nBTTagCompound;
    }

    public NBTTagCompound a(NBTTagCompound nBTTagCompound) {
        NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
        this.a(nBTTagCompound2, nBTTagCompound);
        return nBTTagCompound2;
    }

    private void a(NBTTagCompound nBTTagCompound, NBTTagCompound nBTTagCompound2) {
        nBTTagCompound.setLong("RandomSeed", this.seed);
        nBTTagCompound.setString("generatorName", this.type.name());
        nBTTagCompound.setInt("generatorVersion", this.type.getVersion());
        nBTTagCompound.setInt("GameType", this.gameType.a());
        nBTTagCompound.setBoolean("MapFeatures", this.useMapFeatures);
        nBTTagCompound.setInt("SpawnX", this.spawnX);
        nBTTagCompound.setInt("SpawnY", this.spawnY);
        nBTTagCompound.setInt("SpawnZ", this.spawnZ);
        nBTTagCompound.setLong("Time", this.time);
        nBTTagCompound.setLong("SizeOnDisk", this.sizeOnDisk);
        nBTTagCompound.setLong("LastPlayed", System.currentTimeMillis());
        nBTTagCompound.setString("LevelName", this.name);
        nBTTagCompound.setInt("version", this.version);
        nBTTagCompound.setInt("rainTime", this.rainTicks);
        nBTTagCompound.setBoolean("raining", this.isRaining);
        nBTTagCompound.setInt("thunderTime", this.thunderTicks);
        nBTTagCompound.setBoolean("thundering", this.isThundering);
        nBTTagCompound.setBoolean("hardcore", this.hardcore);
        nBTTagCompound.setBoolean("allowCommands", this.allowCommands);
        nBTTagCompound.setBoolean("initialized", this.initialized);
        if (nBTTagCompound2 != null) {
            nBTTagCompound.setCompound("Player", nBTTagCompound2);
        }
    }

    public long getSeed() {
        return this.seed;
    }

    public int c() {
        return this.spawnX;
    }

    public int d() {
        return this.spawnY;
    }

    public int e() {
        return this.spawnZ;
    }

    public long getTime() {
        return this.time;
    }

    public NBTTagCompound h() {
        return this.playerData;
    }

    public int i() {
        return this.dimension;
    }

    public void b(long l) {
        this.time = l;
    }

    public void setSpawn(int n, int n2, int n3) {
        this.spawnX = n;
        this.spawnY = n2;
        this.spawnZ = n3;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int k() {
        return this.version;
    }

    public void e(int n) {
        this.version = n;
    }

    public boolean isThundering() {
        return this.isThundering;
    }

    public void setThundering(boolean bl) {
        this.isThundering = bl;
    }

    public int getThunderDuration() {
        return this.thunderTicks;
    }

    public void setThunderDuration(int n) {
        this.thunderTicks = n;
    }

    public boolean hasStorm() {
        return this.isRaining;
    }

    public void setStorm(boolean bl) {
        this.isRaining = bl;
    }

    public int getWeatherDuration() {
        return this.rainTicks;
    }

    public void setWeatherDuration(int n) {
        this.rainTicks = n;
    }

    public EnumGamemode getGameType() {
        return this.gameType;
    }

    public boolean shouldGenerateMapFeatures() {
        return this.useMapFeatures;
    }

    public void setGameType(EnumGamemode enumGamemode) {
        this.gameType = enumGamemode;
    }

    public boolean isHardcore() {
        return this.hardcore;
    }

    public WorldType getType() {
        return this.type;
    }

    public void setType(WorldType worldType) {
        this.type = worldType;
    }

    public boolean allowCommands() {
        return this.allowCommands;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void d(boolean bl) {
        this.initialized = bl;
    }
}

