/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.BiomeBase;
import net.minecraft.server.Block;
import net.minecraft.server.BlockFluids;
import net.minecraft.server.BlockStairs;
import net.minecraft.server.BlockStepAbstract;
import net.minecraft.server.Chunk;
import net.minecraft.server.ChunkCache;
import net.minecraft.server.ChunkCoordIntPair;
import net.minecraft.server.ChunkCoordinates;
import net.minecraft.server.ChunkPosition;
import net.minecraft.server.CrashReport;
import net.minecraft.server.CrashReportChunkStats;
import net.minecraft.server.CrashReportEntities;
import net.minecraft.server.CrashReportPlayers;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EnumSkyBlock;
import net.minecraft.server.Explosion;
import net.minecraft.server.IBlockAccess;
import net.minecraft.server.IChunkProvider;
import net.minecraft.server.IDataManager;
import net.minecraft.server.IWorldAccess;
import net.minecraft.server.Material;
import net.minecraft.server.MathHelper;
import net.minecraft.server.MethodProfiler;
import net.minecraft.server.MovingObjectPosition;
import net.minecraft.server.PathEntity;
import net.minecraft.server.Pathfinder;
import net.minecraft.server.TileEntity;
import net.minecraft.server.Vec3D;
import net.minecraft.server.VillageCollection;
import net.minecraft.server.VillageSiege;
import net.minecraft.server.WorldChunkManager;
import net.minecraft.server.WorldData;
import net.minecraft.server.WorldMapBase;
import net.minecraft.server.WorldMapCollection;
import net.minecraft.server.WorldProvider;
import net.minecraft.server.WorldSettings;

public abstract class World
implements IBlockAccess {
    public boolean e = false;
    public List entityList = new ArrayList();
    protected List g = new ArrayList();
    public List tileEntityList = new ArrayList();
    private List a = new ArrayList();
    private List b = new ArrayList();
    public List players = new ArrayList();
    public List j = new ArrayList();
    private long c = 0xFFFFFFL;
    public int k = 0;
    protected int l = new Random().nextInt();
    protected final int m = 1013904223;
    protected float n;
    protected float o;
    protected float p;
    protected float q;
    protected int r = 0;
    public int s = 0;
    public boolean suppressPhysics = false;
    public int difficulty;
    public Random random = new Random();
    public final WorldProvider worldProvider;
    protected List x = new ArrayList();
    protected IChunkProvider chunkProvider;
    protected final IDataManager dataManager;
    protected WorldData worldData;
    public boolean isLoading;
    public WorldMapCollection worldMaps;
    public final VillageCollection villages = new VillageCollection(this);
    protected final VillageSiege siegeManager = new VillageSiege(this);
    public final MethodProfiler methodProfiler;
    private ArrayList d = new ArrayList();
    private boolean L;
    protected boolean allowMonsters = true;
    protected boolean allowAnimals = true;
    protected Set chunkTickList = new HashSet();
    private int M = this.random.nextInt(12000);
    int[] J = new int[32768];
    private List N = new ArrayList();
    public boolean isStatic = false;

    public BiomeBase getBiome(int n, int n2) {
        Chunk chunk;
        if (this.isLoaded(n, 0, n2) && (chunk = this.getChunkAtWorldCoords(n, n2)) != null) {
            return chunk.a(n & 0xF, n2 & 0xF, this.worldProvider.c);
        }
        return this.worldProvider.c.getBiome(n, n2);
    }

    public WorldChunkManager getWorldChunkManager() {
        return this.worldProvider.c;
    }

    public World(IDataManager iDataManager, String string, WorldSettings worldSettings, WorldProvider worldProvider, MethodProfiler methodProfiler) {
        this.dataManager = iDataManager;
        this.methodProfiler = methodProfiler;
        this.worldMaps = new WorldMapCollection(iDataManager);
        this.worldData = iDataManager.getWorldData();
        this.worldProvider = worldProvider != null ? worldProvider : (this.worldData != null && this.worldData.i() != 0 ? WorldProvider.byDimension(this.worldData.i()) : WorldProvider.byDimension(0));
        if (this.worldData == null) {
            this.worldData = new WorldData(worldSettings, string);
        } else {
            this.worldData.setName(string);
        }
        this.worldProvider.a(this);
        this.chunkProvider = this.i();
        if (!this.worldData.isInitialized()) {
            this.a(worldSettings);
            this.worldData.d(true);
        }
        this.v();
        this.a();
    }

    protected abstract IChunkProvider i();

    protected void a(WorldSettings worldSettings) {
        this.worldData.d(true);
    }

    public int b(int n, int n2) {
        int n3 = 63;
        while (!this.isEmpty(n, n3 + 1, n2)) {
            ++n3;
        }
        return this.getTypeId(n, n3, n2);
    }

    public int getTypeId(int n, int n2, int n3) {
        if (n < -30000000 || n3 < -30000000 || n >= 30000000 || n3 >= 30000000) {
            return 0;
        }
        if (n2 < 0) {
            return 0;
        }
        if (n2 >= 256) {
            return 0;
        }
        return this.getChunkAt(n >> 4, n3 >> 4).getTypeId(n & 0xF, n2, n3 & 0xF);
    }

    public int b(int n, int n2, int n3) {
        if (n < -30000000 || n3 < -30000000 || n >= 30000000 || n3 >= 30000000) {
            return 0;
        }
        if (n2 < 0) {
            return 0;
        }
        if (n2 >= 256) {
            return 0;
        }
        return this.getChunkAt(n >> 4, n3 >> 4).b(n & 0xF, n2, n3 & 0xF);
    }

    public boolean isEmpty(int n, int n2, int n3) {
        return this.getTypeId(n, n2, n3) == 0;
    }

    public boolean isTileEntity(int n, int n2, int n3) {
        int n4 = this.getTypeId(n, n2, n3);
        return Block.byId[n4] != null && Block.byId[n4].s();
    }

    public boolean isLoaded(int n, int n2, int n3) {
        if (n2 < 0 || n2 >= 256) {
            return false;
        }
        return this.isChunkLoaded(n >> 4, n3 >> 4);
    }

    public boolean areChunksLoaded(int n, int n2, int n3, int n4) {
        return this.c(n - n4, n2 - n4, n3 - n4, n + n4, n2 + n4, n3 + n4);
    }

    public boolean c(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n5 < 0 || n2 >= 256) {
            return false;
        }
        n3 >>= 4;
        n4 >>= 4;
        n6 >>= 4;
        for (int i = n >>= 4; i <= n4; ++i) {
            for (int j = n3; j <= n6; ++j) {
                if (this.isChunkLoaded(i, j)) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean isChunkLoaded(int n, int n2) {
        return this.chunkProvider.isChunkLoaded(n, n2);
    }

    public Chunk getChunkAtWorldCoords(int n, int n2) {
        return this.getChunkAt(n >> 4, n2 >> 4);
    }

    public Chunk getChunkAt(int n, int n2) {
        return this.chunkProvider.getOrCreateChunk(n, n2);
    }

    public boolean setRawTypeIdAndData(int n, int n2, int n3, int n4, int n5) {
        return this.setRawTypeIdAndData(n, n2, n3, n4, n5, true);
    }

    public boolean setRawTypeIdAndData(int n, int n2, int n3, int n4, int n5, boolean bl) {
        if (n < -30000000 || n3 < -30000000 || n >= 30000000 || n3 >= 30000000) {
            return false;
        }
        if (n2 < 0) {
            return false;
        }
        if (n2 >= 256) {
            return false;
        }
        Chunk chunk = this.getChunkAt(n >> 4, n3 >> 4);
        boolean bl2 = chunk.a(n & 0xF, n2, n3 & 0xF, n4, n5);
        this.methodProfiler.a("checkLight");
        this.x(n, n2, n3);
        this.methodProfiler.b();
        if (bl && bl2 && (this.isStatic || chunk.seenByPlayer)) {
            this.notify(n, n2, n3);
        }
        return bl2;
    }

    public boolean setRawTypeId(int n, int n2, int n3, int n4) {
        if (n < -30000000 || n3 < -30000000 || n >= 30000000 || n3 >= 30000000) {
            return false;
        }
        if (n2 < 0) {
            return false;
        }
        if (n2 >= 256) {
            return false;
        }
        Chunk chunk = this.getChunkAt(n >> 4, n3 >> 4);
        boolean bl = chunk.a(n & 0xF, n2, n3 & 0xF, n4);
        this.methodProfiler.a("checkLight");
        this.x(n, n2, n3);
        this.methodProfiler.b();
        if (bl && (this.isStatic || chunk.seenByPlayer)) {
            this.notify(n, n2, n3);
        }
        return bl;
    }

    public Material getMaterial(int n, int n2, int n3) {
        int n4 = this.getTypeId(n, n2, n3);
        if (n4 == 0) {
            return Material.AIR;
        }
        return Block.byId[n4].material;
    }

    public int getData(int n, int n2, int n3) {
        if (n < -30000000 || n3 < -30000000 || n >= 30000000 || n3 >= 30000000) {
            return 0;
        }
        if (n2 < 0) {
            return 0;
        }
        if (n2 >= 256) {
            return 0;
        }
        Chunk chunk = this.getChunkAt(n >> 4, n3 >> 4);
        return chunk.getData(n &= 0xF, n2, n3 &= 0xF);
    }

    public void setData(int n, int n2, int n3, int n4) {
        if (this.setRawData(n, n2, n3, n4)) {
            this.update(n, n2, n3, this.getTypeId(n, n2, n3));
        }
    }

    public boolean setRawData(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        if (n < -30000000 || n3 < -30000000 || n >= 30000000 || n3 >= 30000000) {
            return false;
        }
        if (n2 < 0) {
            return false;
        }
        if (n2 >= 256) {
            return false;
        }
        Chunk chunk = this.getChunkAt(n >> 4, n3 >> 4);
        boolean bl = chunk.b(n6 = n & 0xF, n2, n5 = n3 & 0xF, n4);
        if (bl && (this.isStatic || chunk.seenByPlayer && Block.r[chunk.getTypeId(n6, n2, n5) & 0xFFF])) {
            this.notify(n, n2, n3);
        }
        return bl;
    }

    public boolean setTypeId(int n, int n2, int n3, int n4) {
        if (this.setRawTypeId(n, n2, n3, n4)) {
            this.update(n, n2, n3, n4);
            return true;
        }
        return false;
    }

    public boolean setTypeIdAndData(int n, int n2, int n3, int n4, int n5) {
        if (this.setRawTypeIdAndData(n, n2, n3, n4, n5)) {
            this.update(n, n2, n3, n4);
            return true;
        }
        return false;
    }

    public void notify(int n, int n2, int n3) {
        for (IWorldAccess iWorldAccess : this.x) {
            iWorldAccess.a(n, n2, n3);
        }
    }

    public void update(int n, int n2, int n3, int n4) {
        this.applyPhysics(n, n2, n3, n4);
    }

    public void g(int n, int n2, int n3, int n4) {
        int n5;
        if (n3 > n4) {
            n5 = n4;
            n4 = n3;
            n3 = n5;
        }
        if (!this.worldProvider.e) {
            for (n5 = n3; n5 <= n4; ++n5) {
                this.c(EnumSkyBlock.SKY, n, n5, n2);
            }
        }
        this.d(n, n3, n2, n, n4, n2);
    }

    public void i(int n, int n2, int n3) {
        for (IWorldAccess iWorldAccess : this.x) {
            iWorldAccess.a(n, n2, n3, n, n2, n3);
        }
    }

    public void d(int n, int n2, int n3, int n4, int n5, int n6) {
        for (IWorldAccess iWorldAccess : this.x) {
            iWorldAccess.a(n, n2, n3, n4, n5, n6);
        }
    }

    public void applyPhysics(int n, int n2, int n3, int n4) {
        this.m(n - 1, n2, n3, n4);
        this.m(n + 1, n2, n3, n4);
        this.m(n, n2 - 1, n3, n4);
        this.m(n, n2 + 1, n3, n4);
        this.m(n, n2, n3 - 1, n4);
        this.m(n, n2, n3 + 1, n4);
    }

    private void m(int n, int n2, int n3, int n4) {
        if (this.suppressPhysics || this.isStatic) {
            return;
        }
        Block block = Block.byId[this.getTypeId(n, n2, n3)];
        if (block != null) {
            block.doPhysics(this, n, n2, n3, n4);
        }
    }

    public boolean j(int n, int n2, int n3) {
        return this.getChunkAt(n >> 4, n3 >> 4).d(n & 0xF, n2, n3 & 0xF);
    }

    public int k(int n, int n2, int n3) {
        if (n2 < 0) {
            return 0;
        }
        if (n2 >= 256) {
            n2 = 255;
        }
        return this.getChunkAt(n >> 4, n3 >> 4).c(n & 0xF, n2, n3 & 0xF, 0);
    }

    public int getLightLevel(int n, int n2, int n3) {
        return this.a(n, n2, n3, true);
    }

    public int a(int n, int n2, int n3, boolean bl) {
        int n4;
        if (n < -30000000 || n3 < -30000000 || n >= 30000000 || n3 >= 30000000) {
            return 15;
        }
        if (bl && ((n4 = this.getTypeId(n, n2, n3)) == Block.STEP.id || n4 == Block.WOOD_STEP.id || n4 == Block.SOIL.id || n4 == Block.COBBLESTONE_STAIRS.id || n4 == Block.WOOD_STAIRS.id)) {
            int n5 = this.a(n, n2 + 1, n3, false);
            int n6 = this.a(n + 1, n2, n3, false);
            int n7 = this.a(n - 1, n2, n3, false);
            int n8 = this.a(n, n2, n3 + 1, false);
            int n9 = this.a(n, n2, n3 - 1, false);
            if (n6 > n5) {
                n5 = n6;
            }
            if (n7 > n5) {
                n5 = n7;
            }
            if (n8 > n5) {
                n5 = n8;
            }
            if (n9 > n5) {
                n5 = n9;
            }
            return n5;
        }
        if (n2 < 0) {
            return 0;
        }
        if (n2 >= 256) {
            n2 = 255;
        }
        Chunk chunk = this.getChunkAt(n >> 4, n3 >> 4);
        return chunk.c(n &= 0xF, n2, n3 &= 0xF, this.k);
    }

    public int getHighestBlockYAt(int n, int n2) {
        if (n < -30000000 || n2 < -30000000 || n >= 30000000 || n2 >= 30000000) {
            return 0;
        }
        if (!this.isChunkLoaded(n >> 4, n2 >> 4)) {
            return 0;
        }
        Chunk chunk = this.getChunkAt(n >> 4, n2 >> 4);
        return chunk.b(n & 0xF, n2 & 0xF);
    }

    public int b(EnumSkyBlock enumSkyBlock, int n, int n2, int n3) {
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 >= 256) {
            n2 = 255;
        }
        if (n < -30000000 || n3 < -30000000 || n >= 30000000 || n3 >= 30000000) {
            return enumSkyBlock.c;
        }
        int n4 = n >> 4;
        int n5 = n3 >> 4;
        if (!this.isChunkLoaded(n4, n5)) {
            return enumSkyBlock.c;
        }
        Chunk chunk = this.getChunkAt(n4, n5);
        return chunk.getBrightness(enumSkyBlock, n & 0xF, n2, n3 & 0xF);
    }

    public void b(EnumSkyBlock enumSkyBlock, int n, int n2, int n3, int n4) {
        if (n < -30000000 || n3 < -30000000 || n >= 30000000 || n3 >= 30000000) {
            return;
        }
        if (n2 < 0) {
            return;
        }
        if (n2 >= 256) {
            return;
        }
        if (!this.isChunkLoaded(n >> 4, n3 >> 4)) {
            return;
        }
        Chunk chunk = this.getChunkAt(n >> 4, n3 >> 4);
        chunk.a(enumSkyBlock, n & 0xF, n2, n3 & 0xF, n4);
        for (IWorldAccess iWorldAccess : this.x) {
            iWorldAccess.b(n, n2, n3);
        }
    }

    public void n(int n, int n2, int n3) {
        for (IWorldAccess iWorldAccess : this.x) {
            iWorldAccess.b(n, n2, n3);
        }
    }

    public float o(int n, int n2, int n3) {
        return this.worldProvider.f[this.getLightLevel(n, n2, n3)];
    }

    public boolean s() {
        return this.k < 4;
    }

    public MovingObjectPosition a(Vec3D vec3D, Vec3D vec3D2) {
        return this.rayTrace(vec3D, vec3D2, false, false);
    }

    public MovingObjectPosition rayTrace(Vec3D vec3D, Vec3D vec3D2, boolean bl) {
        return this.rayTrace(vec3D, vec3D2, bl, false);
    }

    public MovingObjectPosition rayTrace(Vec3D vec3D, Vec3D vec3D2, boolean bl, boolean bl2) {
        MovingObjectPosition movingObjectPosition;
        if (Double.isNaN(vec3D.a) || Double.isNaN(vec3D.b) || Double.isNaN(vec3D.c)) {
            return null;
        }
        if (Double.isNaN(vec3D2.a) || Double.isNaN(vec3D2.b) || Double.isNaN(vec3D2.c)) {
            return null;
        }
        int n = MathHelper.floor(vec3D2.a);
        int n2 = MathHelper.floor(vec3D2.b);
        int n3 = MathHelper.floor(vec3D2.c);
        int n4 = MathHelper.floor(vec3D.a);
        int n5 = MathHelper.floor(vec3D.b);
        int n6 = MathHelper.floor(vec3D.c);
        int n7 = this.getTypeId(n4, n5, n6);
        int n8 = this.getData(n4, n5, n6);
        Block block = Block.byId[n7];
        if ((!bl2 || block == null || block.e(this, n4, n5, n6) != null) && n7 > 0 && block.a(n8, bl) && (movingObjectPosition = block.a(this, n4, n5, n6, vec3D, vec3D2)) != null) {
            return movingObjectPosition;
        }
        n7 = 200;
        while (n7-- >= 0) {
            MovingObjectPosition movingObjectPosition2;
            if (Double.isNaN(vec3D.a) || Double.isNaN(vec3D.b) || Double.isNaN(vec3D.c)) {
                return null;
            }
            if (n4 == n && n5 == n2 && n6 == n3) {
                return null;
            }
            n8 = 1;
            boolean bl3 = true;
            boolean bl4 = true;
            double d = 999.0;
            double d2 = 999.0;
            double d3 = 999.0;
            if (n > n4) {
                d = (double)n4 + 1.0;
            } else if (n < n4) {
                d = (double)n4 + 0.0;
            } else {
                n8 = 0;
            }
            if (n2 > n5) {
                d2 = (double)n5 + 1.0;
            } else if (n2 < n5) {
                d2 = (double)n5 + 0.0;
            } else {
                bl3 = false;
            }
            if (n3 > n6) {
                d3 = (double)n6 + 1.0;
            } else if (n3 < n6) {
                d3 = (double)n6 + 0.0;
            } else {
                bl4 = false;
            }
            double d4 = 999.0;
            double d5 = 999.0;
            double d6 = 999.0;
            double d7 = vec3D2.a - vec3D.a;
            double d8 = vec3D2.b - vec3D.b;
            double d9 = vec3D2.c - vec3D.c;
            if (n8 != 0) {
                d4 = (d - vec3D.a) / d7;
            }
            if (bl3) {
                d5 = (d2 - vec3D.b) / d8;
            }
            if (bl4) {
                d6 = (d3 - vec3D.c) / d9;
            }
            int n9 = 0;
            if (d4 < d5 && d4 < d6) {
                n9 = n > n4 ? 4 : 5;
                vec3D.a = d;
                vec3D.b += d8 * d4;
                vec3D.c += d9 * d4;
            } else if (d5 < d6) {
                n9 = n2 > n5 ? 0 : 1;
                vec3D.a += d7 * d5;
                vec3D.b = d2;
                vec3D.c += d9 * d5;
            } else {
                n9 = n3 > n6 ? 2 : 3;
                vec3D.a += d7 * d6;
                vec3D.b += d8 * d6;
                vec3D.c = d3;
            }
            Vec3D vec3D3 = Vec3D.a().create(vec3D.a, vec3D.b, vec3D.c);
            vec3D3.a = MathHelper.floor(vec3D.a);
            n4 = (int)vec3D3.a;
            if (n9 == 5) {
                --n4;
                vec3D3.a += 1.0;
            }
            vec3D3.b = MathHelper.floor(vec3D.b);
            n5 = (int)vec3D3.b;
            if (n9 == 1) {
                --n5;
                vec3D3.b += 1.0;
            }
            vec3D3.c = MathHelper.floor(vec3D.c);
            n6 = (int)vec3D3.c;
            if (n9 == 3) {
                --n6;
                vec3D3.c += 1.0;
            }
            int n10 = this.getTypeId(n4, n5, n6);
            int n11 = this.getData(n4, n5, n6);
            Block block2 = Block.byId[n10];
            if (bl2 && block2 != null && block2.e(this, n4, n5, n6) == null || n10 <= 0 || !block2.a(n11, bl) || (movingObjectPosition2 = block2.a(this, n4, n5, n6, vec3D, vec3D2)) == null) continue;
            return movingObjectPosition2;
        }
        return null;
    }

    public void makeSound(Entity entity, String string, float f, float f2) {
        if (entity == null || string == null) {
            return;
        }
        for (IWorldAccess iWorldAccess : this.x) {
            iWorldAccess.a(string, entity.locX, entity.locY - (double)entity.height, entity.locZ, f, f2);
        }
    }

    public void makeSound(double d, double d2, double d3, String string, float f, float f2) {
        if (string == null) {
            return;
        }
        for (IWorldAccess iWorldAccess : this.x) {
            iWorldAccess.a(string, d, d2, d3, f, f2);
        }
    }

    public void a(String string, int n, int n2, int n3) {
        for (IWorldAccess iWorldAccess : this.x) {
            iWorldAccess.a(string, n, n2, n3);
        }
    }

    public void a(String string, double d, double d2, double d3, double d4, double d5, double d6) {
        for (IWorldAccess iWorldAccess : this.x) {
            iWorldAccess.a(string, d, d2, d3, d4, d5, d6);
        }
    }

    public boolean strikeLightning(Entity entity) {
        this.j.add(entity);
        return true;
    }

    public boolean addEntity(Entity entity) {
        int n = MathHelper.floor(entity.locX / 16.0);
        int n2 = MathHelper.floor(entity.locZ / 16.0);
        boolean bl = false;
        if (entity instanceof EntityHuman) {
            bl = true;
        }
        if (bl || this.isChunkLoaded(n, n2)) {
            if (entity instanceof EntityHuman) {
                EntityHuman entityHuman = (EntityHuman)entity;
                this.players.add(entityHuman);
                this.everyoneSleeping();
            }
            this.getChunkAt(n, n2).a(entity);
            this.entityList.add(entity);
            this.a(entity);
            return true;
        }
        return false;
    }

    protected void a(Entity entity) {
        for (IWorldAccess iWorldAccess : this.x) {
            iWorldAccess.a(entity);
        }
    }

    protected void b(Entity entity) {
        for (IWorldAccess iWorldAccess : this.x) {
            iWorldAccess.b(entity);
        }
    }

    public void kill(Entity entity) {
        if (entity.passenger != null) {
            entity.passenger.mount(null);
        }
        if (entity.vehicle != null) {
            entity.mount(null);
        }
        entity.die();
        if (entity instanceof EntityHuman) {
            this.players.remove(entity);
            this.everyoneSleeping();
        }
    }

    public void removeEntity(Entity entity) {
        entity.die();
        if (entity instanceof EntityHuman) {
            this.players.remove(entity);
            this.everyoneSleeping();
        }
        int n = entity.ah;
        int n2 = entity.aj;
        if (entity.ag && this.isChunkLoaded(n, n2)) {
            this.getChunkAt(n, n2).b(entity);
        }
        this.entityList.remove(entity);
        this.b(entity);
    }

    public void addIWorldAccess(IWorldAccess iWorldAccess) {
        this.x.add(iWorldAccess);
    }

    public List getCubes(Entity entity, AxisAlignedBB axisAlignedBB) {
        this.d.clear();
        int n = MathHelper.floor(axisAlignedBB.a);
        int n2 = MathHelper.floor(axisAlignedBB.d + 1.0);
        int n3 = MathHelper.floor(axisAlignedBB.b);
        int n4 = MathHelper.floor(axisAlignedBB.e + 1.0);
        int n5 = MathHelper.floor(axisAlignedBB.c);
        int n6 = MathHelper.floor(axisAlignedBB.f + 1.0);
        for (int i = n; i < n2; ++i) {
            for (int j = n5; j < n6; ++j) {
                if (!this.isLoaded(i, 64, j)) continue;
                for (int k = n3 - 1; k < n4; ++k) {
                    Block block = Block.byId[this.getTypeId(i, k, j)];
                    if (block == null) continue;
                    block.a(this, i, k, j, axisAlignedBB, this.d, entity);
                }
            }
        }
        double d = 0.25;
        List list = this.getEntities(entity, axisAlignedBB.grow(d, d, d));
        for (Entity entity2 : list) {
            AxisAlignedBB axisAlignedBB2 = entity2.E();
            if (axisAlignedBB2 != null && axisAlignedBB2.a(axisAlignedBB)) {
                this.d.add(axisAlignedBB2);
            }
            if ((axisAlignedBB2 = entity.g(entity2)) == null || !axisAlignedBB2.a(axisAlignedBB)) continue;
            this.d.add(axisAlignedBB2);
        }
        return this.d;
    }

    public List a(AxisAlignedBB axisAlignedBB) {
        this.d.clear();
        int n = MathHelper.floor(axisAlignedBB.a);
        int n2 = MathHelper.floor(axisAlignedBB.d + 1.0);
        int n3 = MathHelper.floor(axisAlignedBB.b);
        int n4 = MathHelper.floor(axisAlignedBB.e + 1.0);
        int n5 = MathHelper.floor(axisAlignedBB.c);
        int n6 = MathHelper.floor(axisAlignedBB.f + 1.0);
        for (int i = n; i < n2; ++i) {
            for (int j = n5; j < n6; ++j) {
                if (!this.isLoaded(i, 64, j)) continue;
                for (int k = n3 - 1; k < n4; ++k) {
                    Block block = Block.byId[this.getTypeId(i, k, j)];
                    if (block == null) continue;
                    block.a(this, i, k, j, axisAlignedBB, this.d, null);
                }
            }
        }
        return this.d;
    }

    public int a(float f) {
        float f2 = this.c(f);
        float f3 = 1.0f - (MathHelper.cos(f2 * (float)Math.PI * 2.0f) * 2.0f + 0.5f);
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        if (f3 > 1.0f) {
            f3 = 1.0f;
        }
        f3 = 1.0f - f3;
        f3 = (float)((double)f3 * (1.0 - (double)(this.j(f) * 5.0f) / 16.0));
        f3 = (float)((double)f3 * (1.0 - (double)(this.i(f) * 5.0f) / 16.0));
        f3 = 1.0f - f3;
        return (int)(f3 * 11.0f);
    }

    public float c(float f) {
        return this.worldProvider.a(this.worldData.getTime(), f);
    }

    public int g(int n, int n2) {
        return this.getChunkAtWorldCoords(n, n2).d(n & 0xF, n2 & 0xF);
    }

    public int h(int n, int n2) {
        Chunk chunk = this.getChunkAtWorldCoords(n, n2);
        n &= 0xF;
        n2 &= 0xF;
        for (int i = chunk.h() + 15; i > 0; --i) {
            int n3 = chunk.getTypeId(n, i, n2);
            if (n3 == 0 || !Block.byId[n3].material.isSolid() || Block.byId[n3].material == Material.LEAVES) {
                continue;
            }
            return i + 1;
        }
        return -1;
    }

    public void a(int n, int n2, int n3, int n4, int n5) {
    }

    public void b(int n, int n2, int n3, int n4, int n5) {
    }

    public void tickEntities() {
        int n;
        int n2;
        Object object2;
        this.methodProfiler.a("entities");
        this.methodProfiler.a("global");
        for (int i = 0; i < this.j.size(); ++i) {
            object2 = (Entity)this.j.get(i);
            ((Entity)object2).h_();
            if (!((Entity)object2).dead) continue;
            this.j.remove(i--);
        }
        this.methodProfiler.c("remove");
        this.entityList.removeAll(this.g);
        for (Object object2 : this.g) {
            n2 = ((Entity)object2).ah;
            n = ((Entity)object2).aj;
            if (!((Entity)object2).ag || !this.isChunkLoaded(n2, n)) continue;
            this.getChunkAt(n2, n).b((Entity)object2);
        }
        for (Object object2 : this.g) {
            this.b((Entity)object2);
        }
        this.g.clear();
        this.methodProfiler.c("regular");
        for (int i = 0; i < this.entityList.size(); ++i) {
            object2 = (Entity)this.entityList.get(i);
            if (((Entity)object2).vehicle != null) {
                if (!((Entity)object2).vehicle.dead && ((Entity)object2).vehicle.passenger == object2) continue;
                ((Entity)object2).vehicle.passenger = null;
                ((Entity)object2).vehicle = null;
            }
            this.methodProfiler.a("tick");
            if (!((Entity)object2).dead) {
                this.playerJoinedWorld((Entity)object2);
            }
            this.methodProfiler.b();
            this.methodProfiler.a("remove");
            if (((Entity)object2).dead) {
                n2 = ((Entity)object2).ah;
                n = ((Entity)object2).aj;
                if (((Entity)object2).ag && this.isChunkLoaded(n2, n)) {
                    this.getChunkAt(n2, n).b((Entity)object2);
                }
                this.entityList.remove(i--);
                this.b((Entity)object2);
            }
            this.methodProfiler.b();
        }
        this.methodProfiler.c("tileEntities");
        this.L = true;
        Iterator iterator = this.tileEntityList.iterator();
        while (iterator.hasNext()) {
            Chunk chunk;
            object2 = (TileEntity)iterator.next();
            if (!((TileEntity)object2).p() && ((TileEntity)object2).m() && this.isLoaded(((TileEntity)object2).x, ((TileEntity)object2).y, ((TileEntity)object2).z)) {
                ((TileEntity)object2).g();
            }
            if (!((TileEntity)object2).p()) continue;
            iterator.remove();
            if (!this.isChunkLoaded(((TileEntity)object2).x >> 4, ((TileEntity)object2).z >> 4) || (chunk = this.getChunkAt(((TileEntity)object2).x >> 4, ((TileEntity)object2).z >> 4)) == null) continue;
            chunk.f(((TileEntity)object2).x & 0xF, ((TileEntity)object2).y, ((TileEntity)object2).z & 0xF);
        }
        this.L = false;
        if (!this.b.isEmpty()) {
            this.tileEntityList.removeAll(this.b);
            this.b.clear();
        }
        this.methodProfiler.c("pendingTileEntities");
        if (!this.a.isEmpty()) {
            for (TileEntity tileEntity : this.a) {
                Chunk chunk;
                if (tileEntity.p()) continue;
                if (!this.tileEntityList.contains(tileEntity)) {
                    this.tileEntityList.add(tileEntity);
                }
                if (this.isChunkLoaded(tileEntity.x >> 4, tileEntity.z >> 4) && (chunk = this.getChunkAt(tileEntity.x >> 4, tileEntity.z >> 4)) != null) {
                    chunk.a(tileEntity.x & 0xF, tileEntity.y, tileEntity.z & 0xF, tileEntity);
                }
                this.notify(tileEntity.x, tileEntity.y, tileEntity.z);
            }
            this.a.clear();
        }
        this.methodProfiler.b();
        this.methodProfiler.b();
    }

    public void a(Collection collection) {
        if (this.L) {
            this.a.addAll(collection);
        } else {
            this.tileEntityList.addAll(collection);
        }
    }

    public void playerJoinedWorld(Entity entity) {
        this.entityJoinedWorld(entity, true);
    }

    public void entityJoinedWorld(Entity entity, boolean bl) {
        int n = MathHelper.floor(entity.locX);
        int n2 = MathHelper.floor(entity.locZ);
        int n3 = 32;
        if (bl && !this.c(n - n3, 0, n2 - n3, n + n3, 0, n2 + n3)) {
            return;
        }
        entity.S = entity.locX;
        entity.T = entity.locY;
        entity.U = entity.locZ;
        entity.lastYaw = entity.yaw;
        entity.lastPitch = entity.pitch;
        if (bl && entity.ag) {
            if (entity.vehicle != null) {
                entity.U();
            } else {
                entity.h_();
            }
        }
        this.methodProfiler.a("chunkCheck");
        if (Double.isNaN(entity.locX) || Double.isInfinite(entity.locX)) {
            entity.locX = entity.S;
        }
        if (Double.isNaN(entity.locY) || Double.isInfinite(entity.locY)) {
            entity.locY = entity.T;
        }
        if (Double.isNaN(entity.locZ) || Double.isInfinite(entity.locZ)) {
            entity.locZ = entity.U;
        }
        if (Double.isNaN(entity.pitch) || Double.isInfinite(entity.pitch)) {
            entity.pitch = entity.lastPitch;
        }
        if (Double.isNaN(entity.yaw) || Double.isInfinite(entity.yaw)) {
            entity.yaw = entity.lastYaw;
        }
        int n4 = MathHelper.floor(entity.locX / 16.0);
        int n5 = MathHelper.floor(entity.locY / 16.0);
        int n6 = MathHelper.floor(entity.locZ / 16.0);
        if (!entity.ag || entity.ah != n4 || entity.ai != n5 || entity.aj != n6) {
            if (entity.ag && this.isChunkLoaded(entity.ah, entity.aj)) {
                this.getChunkAt(entity.ah, entity.aj).a(entity, entity.ai);
            }
            if (this.isChunkLoaded(n4, n6)) {
                entity.ag = true;
                this.getChunkAt(n4, n6).a(entity);
            } else {
                entity.ag = false;
            }
        }
        this.methodProfiler.b();
        if (bl && entity.ag && entity.passenger != null) {
            if (entity.passenger.dead || entity.passenger.vehicle != entity) {
                entity.passenger.vehicle = null;
                entity.passenger = null;
            } else {
                this.playerJoinedWorld(entity.passenger);
            }
        }
    }

    public boolean b(AxisAlignedBB axisAlignedBB) {
        return this.a(axisAlignedBB, (Entity)null);
    }

    public boolean a(AxisAlignedBB axisAlignedBB, Entity entity) {
        List list = this.getEntities(null, axisAlignedBB);
        for (Entity entity2 : list) {
            if (entity2.dead || !entity2.m || entity2 == entity) continue;
            return false;
        }
        return true;
    }

    public boolean c(AxisAlignedBB axisAlignedBB) {
        int n = MathHelper.floor(axisAlignedBB.a);
        int n2 = MathHelper.floor(axisAlignedBB.d + 1.0);
        int n3 = MathHelper.floor(axisAlignedBB.b);
        int n4 = MathHelper.floor(axisAlignedBB.e + 1.0);
        int n5 = MathHelper.floor(axisAlignedBB.c);
        int n6 = MathHelper.floor(axisAlignedBB.f + 1.0);
        if (axisAlignedBB.a < 0.0) {
            --n;
        }
        if (axisAlignedBB.b < 0.0) {
            --n3;
        }
        if (axisAlignedBB.c < 0.0) {
            --n5;
        }
        for (int i = n; i < n2; ++i) {
            for (int j = n3; j < n4; ++j) {
                for (int k = n5; k < n6; ++k) {
                    Block block = Block.byId[this.getTypeId(i, j, k)];
                    if (block == null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean containsLiquid(AxisAlignedBB axisAlignedBB) {
        int n = MathHelper.floor(axisAlignedBB.a);
        int n2 = MathHelper.floor(axisAlignedBB.d + 1.0);
        int n3 = MathHelper.floor(axisAlignedBB.b);
        int n4 = MathHelper.floor(axisAlignedBB.e + 1.0);
        int n5 = MathHelper.floor(axisAlignedBB.c);
        int n6 = MathHelper.floor(axisAlignedBB.f + 1.0);
        if (axisAlignedBB.a < 0.0) {
            --n;
        }
        if (axisAlignedBB.b < 0.0) {
            --n3;
        }
        if (axisAlignedBB.c < 0.0) {
            --n5;
        }
        for (int i = n; i < n2; ++i) {
            for (int j = n3; j < n4; ++j) {
                for (int k = n5; k < n6; ++k) {
                    Block block = Block.byId[this.getTypeId(i, j, k)];
                    if (block == null || !block.material.isLiquid()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean e(AxisAlignedBB axisAlignedBB) {
        int n;
        int n2 = MathHelper.floor(axisAlignedBB.a);
        int n3 = MathHelper.floor(axisAlignedBB.d + 1.0);
        int n4 = MathHelper.floor(axisAlignedBB.b);
        int n5 = MathHelper.floor(axisAlignedBB.e + 1.0);
        int n6 = MathHelper.floor(axisAlignedBB.c);
        if (this.c(n2, n4, n6, n3, n5, n = MathHelper.floor(axisAlignedBB.f + 1.0))) {
            for (int i = n2; i < n3; ++i) {
                for (int j = n4; j < n5; ++j) {
                    for (int k = n6; k < n; ++k) {
                        int n7 = this.getTypeId(i, j, k);
                        if (n7 != Block.FIRE.id && n7 != Block.LAVA.id && n7 != Block.STATIONARY_LAVA.id) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean a(AxisAlignedBB axisAlignedBB, Material material, Entity entity) {
        int n;
        int n2 = MathHelper.floor(axisAlignedBB.a);
        int n3 = MathHelper.floor(axisAlignedBB.d + 1.0);
        int n4 = MathHelper.floor(axisAlignedBB.b);
        int n5 = MathHelper.floor(axisAlignedBB.e + 1.0);
        int n6 = MathHelper.floor(axisAlignedBB.c);
        if (!this.c(n2, n4, n6, n3, n5, n = MathHelper.floor(axisAlignedBB.f + 1.0))) {
            return false;
        }
        boolean bl = false;
        Vec3D vec3D = Vec3D.a().create(0.0, 0.0, 0.0);
        for (int i = n2; i < n3; ++i) {
            for (int j = n4; j < n5; ++j) {
                for (int k = n6; k < n; ++k) {
                    double d;
                    Block block = Block.byId[this.getTypeId(i, j, k)];
                    if (block == null || block.material != material || !((double)n5 >= (d = (double)((float)(j + 1) - BlockFluids.d(this.getData(i, j, k)))))) continue;
                    bl = true;
                    block.a(this, i, j, k, entity, vec3D);
                }
            }
        }
        if (vec3D.c() > 0.0) {
            vec3D = vec3D.b();
            double d = 0.014;
            entity.motX += vec3D.a * d;
            entity.motY += vec3D.b * d;
            entity.motZ += vec3D.c * d;
        }
        return bl;
    }

    public boolean a(AxisAlignedBB axisAlignedBB, Material material) {
        int n = MathHelper.floor(axisAlignedBB.a);
        int n2 = MathHelper.floor(axisAlignedBB.d + 1.0);
        int n3 = MathHelper.floor(axisAlignedBB.b);
        int n4 = MathHelper.floor(axisAlignedBB.e + 1.0);
        int n5 = MathHelper.floor(axisAlignedBB.c);
        int n6 = MathHelper.floor(axisAlignedBB.f + 1.0);
        for (int i = n; i < n2; ++i) {
            for (int j = n3; j < n4; ++j) {
                for (int k = n5; k < n6; ++k) {
                    Block block = Block.byId[this.getTypeId(i, j, k)];
                    if (block == null || block.material != material) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean b(AxisAlignedBB axisAlignedBB, Material material) {
        int n = MathHelper.floor(axisAlignedBB.a);
        int n2 = MathHelper.floor(axisAlignedBB.d + 1.0);
        int n3 = MathHelper.floor(axisAlignedBB.b);
        int n4 = MathHelper.floor(axisAlignedBB.e + 1.0);
        int n5 = MathHelper.floor(axisAlignedBB.c);
        int n6 = MathHelper.floor(axisAlignedBB.f + 1.0);
        for (int i = n; i < n2; ++i) {
            for (int j = n3; j < n4; ++j) {
                for (int k = n5; k < n6; ++k) {
                    Block block = Block.byId[this.getTypeId(i, j, k)];
                    if (block == null || block.material != material) continue;
                    int n7 = this.getData(i, j, k);
                    double d = j + 1;
                    if (n7 < 8) {
                        d = (double)(j + 1) - (double)n7 / 8.0;
                    }
                    if (!(d >= axisAlignedBB.b)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Explosion explode(Entity entity, double d, double d2, double d3, float f) {
        return this.createExplosion(entity, d, d2, d3, f, false);
    }

    public Explosion createExplosion(Entity entity, double d, double d2, double d3, float f, boolean bl) {
        Explosion explosion = new Explosion(this, entity, d, d2, d3, f);
        explosion.a = bl;
        explosion.a();
        explosion.a(true);
        return explosion;
    }

    public float a(Vec3D vec3D, AxisAlignedBB axisAlignedBB) {
        double d = 1.0 / ((axisAlignedBB.d - axisAlignedBB.a) * 2.0 + 1.0);
        double d2 = 1.0 / ((axisAlignedBB.e - axisAlignedBB.b) * 2.0 + 1.0);
        double d3 = 1.0 / ((axisAlignedBB.f - axisAlignedBB.c) * 2.0 + 1.0);
        int n = 0;
        int n2 = 0;
        float f = 0.0f;
        while (f <= 1.0f) {
            float f2 = 0.0f;
            while (f2 <= 1.0f) {
                float f3 = 0.0f;
                while (f3 <= 1.0f) {
                    double d4 = axisAlignedBB.a + (axisAlignedBB.d - axisAlignedBB.a) * (double)f;
                    double d5 = axisAlignedBB.b + (axisAlignedBB.e - axisAlignedBB.b) * (double)f2;
                    double d6 = axisAlignedBB.c + (axisAlignedBB.f - axisAlignedBB.c) * (double)f3;
                    if (this.a(Vec3D.a().create(d4, d5, d6), vec3D) == null) {
                        ++n;
                    }
                    ++n2;
                    f3 = (float)((double)f3 + d3);
                }
                f2 = (float)((double)f2 + d2);
            }
            f = (float)((double)f + d);
        }
        return (float)n / (float)n2;
    }

    public boolean douseFire(EntityHuman entityHuman, int n, int n2, int n3, int n4) {
        if (n4 == 0) {
            --n2;
        }
        if (n4 == 1) {
            ++n2;
        }
        if (n4 == 2) {
            --n3;
        }
        if (n4 == 3) {
            ++n3;
        }
        if (n4 == 4) {
            --n;
        }
        if (n4 == 5) {
            ++n;
        }
        if (this.getTypeId(n, n2, n3) == Block.FIRE.id) {
            this.a(entityHuman, 1004, n, n2, n3, 0);
            this.setTypeId(n, n2, n3, 0);
            return true;
        }
        return false;
    }

    public TileEntity getTileEntity(int n, int n2, int n3) {
        if (n2 >= 256) {
            return null;
        }
        Chunk chunk = this.getChunkAt(n >> 4, n3 >> 4);
        if (chunk != null) {
            TileEntity tileEntity = chunk.e(n & 0xF, n2, n3 & 0xF);
            if (tileEntity == null) {
                for (TileEntity tileEntity2 : this.a) {
                    if (tileEntity2.p() || tileEntity2.x != n || tileEntity2.y != n2 || tileEntity2.z != n3) continue;
                    tileEntity = tileEntity2;
                    break;
                }
            }
            return tileEntity;
        }
        return null;
    }

    public void setTileEntity(int n, int n2, int n3, TileEntity tileEntity) {
        if (tileEntity != null && !tileEntity.p()) {
            if (this.L) {
                tileEntity.x = n;
                tileEntity.y = n2;
                tileEntity.z = n3;
                this.a.add(tileEntity);
            } else {
                this.tileEntityList.add(tileEntity);
                Chunk chunk = this.getChunkAt(n >> 4, n3 >> 4);
                if (chunk != null) {
                    chunk.a(n & 0xF, n2, n3 & 0xF, tileEntity);
                }
            }
        }
    }

    public void q(int n, int n2, int n3) {
        TileEntity tileEntity = this.getTileEntity(n, n2, n3);
        if (tileEntity != null && this.L) {
            tileEntity.j();
            this.a.remove(tileEntity);
        } else {
            Chunk chunk;
            if (tileEntity != null) {
                this.a.remove(tileEntity);
                this.tileEntityList.remove(tileEntity);
            }
            if ((chunk = this.getChunkAt(n >> 4, n3 >> 4)) != null) {
                chunk.f(n & 0xF, n2, n3 & 0xF);
            }
        }
    }

    public void a(TileEntity tileEntity) {
        this.b.add(tileEntity);
    }

    public boolean r(int n, int n2, int n3) {
        Block block = Block.byId[this.getTypeId(n, n2, n3)];
        if (block == null) {
            return false;
        }
        return block.d();
    }

    public boolean s(int n, int n2, int n3) {
        return Block.i(this.getTypeId(n, n2, n3));
    }

    public boolean t(int n, int n2, int n3) {
        Block block = Block.byId[this.getTypeId(n, n2, n3)];
        if (block == null) {
            return false;
        }
        if (block.material.k() && block.c()) {
            return true;
        }
        if (block instanceof BlockStairs) {
            return (this.getData(n, n2, n3) & 4) == 4;
        }
        if (block instanceof BlockStepAbstract) {
            return (this.getData(n, n2, n3) & 8) == 8;
        }
        return false;
    }

    public boolean b(int n, int n2, int n3, boolean bl) {
        if (n < -30000000 || n3 < -30000000 || n >= 30000000 || n3 >= 30000000) {
            return bl;
        }
        Chunk chunk = this.chunkProvider.getOrCreateChunk(n >> 4, n3 >> 4);
        if (chunk == null || chunk.isEmpty()) {
            return bl;
        }
        Block block = Block.byId[this.getTypeId(n, n2, n3)];
        if (block == null) {
            return false;
        }
        return block.material.k() && block.c();
    }

    public void v() {
        int n = this.a(1.0f);
        if (n != this.k) {
            this.k = n;
        }
    }

    public void setSpawnFlags(boolean bl, boolean bl2) {
        this.allowMonsters = bl;
        this.allowAnimals = bl2;
    }

    public void doTick() {
        this.m();
    }

    private void a() {
        if (this.worldData.hasStorm()) {
            this.o = 1.0f;
            if (this.worldData.isThundering()) {
                this.q = 1.0f;
            }
        }
    }

    protected void m() {
        int n;
        if (this.worldProvider.e) {
            return;
        }
        if (this.r > 0) {
            --this.r;
        }
        if ((n = this.worldData.getThunderDuration()) <= 0) {
            if (this.worldData.isThundering()) {
                this.worldData.setThunderDuration(this.random.nextInt(12000) + 3600);
            } else {
                this.worldData.setThunderDuration(this.random.nextInt(168000) + 12000);
            }
        } else {
            this.worldData.setThunderDuration(--n);
            if (n <= 0) {
                this.worldData.setThundering(!this.worldData.isThundering());
            }
        }
        int n2 = this.worldData.getWeatherDuration();
        if (n2 <= 0) {
            if (this.worldData.hasStorm()) {
                this.worldData.setWeatherDuration(this.random.nextInt(12000) + 12000);
            } else {
                this.worldData.setWeatherDuration(this.random.nextInt(168000) + 12000);
            }
        } else {
            this.worldData.setWeatherDuration(--n2);
            if (n2 <= 0) {
                this.worldData.setStorm(!this.worldData.hasStorm());
            }
        }
        this.n = this.o;
        this.o = this.worldData.hasStorm() ? (float)((double)this.o + 0.01) : (float)((double)this.o - 0.01);
        if (this.o < 0.0f) {
            this.o = 0.0f;
        }
        if (this.o > 1.0f) {
            this.o = 1.0f;
        }
        this.p = this.q;
        this.q = this.worldData.isThundering() ? (float)((double)this.q + 0.01) : (float)((double)this.q - 0.01);
        if (this.q < 0.0f) {
            this.q = 0.0f;
        }
        if (this.q > 1.0f) {
            this.q = 1.0f;
        }
    }

    public void w() {
        this.worldData.setWeatherDuration(1);
    }

    protected void x() {
        int n;
        int n2;
        int n3;
        EntityHuman entityHuman;
        int n4;
        this.chunkTickList.clear();
        this.methodProfiler.a("buildList");
        for (n4 = 0; n4 < this.players.size(); ++n4) {
            entityHuman = (EntityHuman)this.players.get(n4);
            n3 = MathHelper.floor(entityHuman.locX / 16.0);
            n2 = MathHelper.floor(entityHuman.locZ / 16.0);
            n = 7;
            for (int i = -n; i <= n; ++i) {
                for (int j = -n; j <= n; ++j) {
                    this.chunkTickList.add(new ChunkCoordIntPair(i + n3, j + n2));
                }
            }
        }
        this.methodProfiler.b();
        if (this.M > 0) {
            --this.M;
        }
        this.methodProfiler.a("playerCheckLight");
        if (!this.players.isEmpty()) {
            n4 = this.random.nextInt(this.players.size());
            entityHuman = (EntityHuman)this.players.get(n4);
            n3 = MathHelper.floor(entityHuman.locX) + this.random.nextInt(11) - 5;
            n2 = MathHelper.floor(entityHuman.locY) + this.random.nextInt(11) - 5;
            n = MathHelper.floor(entityHuman.locZ) + this.random.nextInt(11) - 5;
            this.x(n3, n2, n);
        }
        this.methodProfiler.b();
    }

    protected void a(int n, int n2, Chunk chunk) {
        this.methodProfiler.c("moodSound");
        if (this.M == 0) {
            EntityHuman entityHuman;
            this.l = this.l * 3 + 1013904223;
            int n3 = this.l >> 2;
            int n4 = n3 & 0xF;
            int n5 = n3 >> 8 & 0xF;
            int n6 = n3 >> 16 & 0x7F;
            int n7 = chunk.getTypeId(n4, n6, n5);
            if (n7 == 0 && this.k(n4 += n, n6, n5 += n2) <= this.random.nextInt(8) && this.b(EnumSkyBlock.SKY, n4, n6, n5) <= 0 && (entityHuman = this.findNearbyPlayer((double)n4 + 0.5, (double)n6 + 0.5, (double)n5 + 0.5, 8.0)) != null && entityHuman.e((double)n4 + 0.5, (double)n6 + 0.5, (double)n5 + 0.5) > 4.0) {
                this.makeSound((double)n4 + 0.5, (double)n6 + 0.5, (double)n5 + 0.5, "ambient.cave.cave", 0.7f, 0.8f + this.random.nextFloat() * 0.2f);
                this.M = this.random.nextInt(12000) + 6000;
            }
        }
        this.methodProfiler.c("checkLight");
        chunk.o();
    }

    protected void g() {
        this.x();
    }

    public boolean u(int n, int n2, int n3) {
        return this.c(n, n2, n3, false);
    }

    public boolean v(int n, int n2, int n3) {
        return this.c(n, n2, n3, true);
    }

    public boolean c(int n, int n2, int n3, boolean bl) {
        int n4;
        BiomeBase biomeBase = this.getBiome(n, n3);
        float f = biomeBase.j();
        if (f > 0.15f) {
            return false;
        }
        if (n2 >= 0 && n2 < 256 && this.b(EnumSkyBlock.BLOCK, n, n2, n3) < 10 && ((n4 = this.getTypeId(n, n2, n3)) == Block.STATIONARY_WATER.id || n4 == Block.WATER.id) && this.getData(n, n2, n3) == 0) {
            if (!bl) {
                return true;
            }
            boolean bl2 = true;
            if (bl2 && this.getMaterial(n - 1, n2, n3) != Material.WATER) {
                bl2 = false;
            }
            if (bl2 && this.getMaterial(n + 1, n2, n3) != Material.WATER) {
                bl2 = false;
            }
            if (bl2 && this.getMaterial(n, n2, n3 - 1) != Material.WATER) {
                bl2 = false;
            }
            if (bl2 && this.getMaterial(n, n2, n3 + 1) != Material.WATER) {
                bl2 = false;
            }
            if (!bl2) {
                return true;
            }
        }
        return false;
    }

    public boolean w(int n, int n2, int n3) {
        BiomeBase biomeBase = this.getBiome(n, n3);
        float f = biomeBase.j();
        if (f > 0.15f) {
            return false;
        }
        if (n2 >= 0 && n2 < 256 && this.b(EnumSkyBlock.BLOCK, n, n2, n3) < 10) {
            int n4 = this.getTypeId(n, n2 - 1, n3);
            int n5 = this.getTypeId(n, n2, n3);
            if (n5 == 0 && Block.SNOW.canPlace(this, n, n2, n3) && n4 != 0 && n4 != Block.ICE.id && Block.byId[n4].material.isSolid()) {
                return true;
            }
        }
        return false;
    }

    public void x(int n, int n2, int n3) {
        if (!this.worldProvider.e) {
            this.c(EnumSkyBlock.SKY, n, n2, n3);
        }
        this.c(EnumSkyBlock.BLOCK, n, n2, n3);
    }

    private int a(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        if (this.j(n2, n3, n4)) {
            n7 = 15;
        } else {
            if (n6 == 0) {
                n6 = 1;
            }
            int n8 = this.b(EnumSkyBlock.SKY, n2 - 1, n3, n4) - n6;
            int n9 = this.b(EnumSkyBlock.SKY, n2 + 1, n3, n4) - n6;
            int n10 = this.b(EnumSkyBlock.SKY, n2, n3 - 1, n4) - n6;
            int n11 = this.b(EnumSkyBlock.SKY, n2, n3 + 1, n4) - n6;
            int n12 = this.b(EnumSkyBlock.SKY, n2, n3, n4 - 1) - n6;
            int n13 = this.b(EnumSkyBlock.SKY, n2, n3, n4 + 1) - n6;
            if (n8 > n7) {
                n7 = n8;
            }
            if (n9 > n7) {
                n7 = n9;
            }
            if (n10 > n7) {
                n7 = n10;
            }
            if (n11 > n7) {
                n7 = n11;
            }
            if (n12 > n7) {
                n7 = n12;
            }
            if (n13 > n7) {
                n7 = n13;
            }
        }
        return n7;
    }

    private int f(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = Block.lightEmission[n5];
        int n8 = this.b(EnumSkyBlock.BLOCK, n2 - 1, n3, n4) - n6;
        int n9 = this.b(EnumSkyBlock.BLOCK, n2 + 1, n3, n4) - n6;
        int n10 = this.b(EnumSkyBlock.BLOCK, n2, n3 - 1, n4) - n6;
        int n11 = this.b(EnumSkyBlock.BLOCK, n2, n3 + 1, n4) - n6;
        int n12 = this.b(EnumSkyBlock.BLOCK, n2, n3, n4 - 1) - n6;
        int n13 = this.b(EnumSkyBlock.BLOCK, n2, n3, n4 + 1) - n6;
        if (n8 > n7) {
            n7 = n8;
        }
        if (n9 > n7) {
            n7 = n9;
        }
        if (n10 > n7) {
            n7 = n10;
        }
        if (n11 > n7) {
            n7 = n11;
        }
        if (n12 > n7) {
            n7 = n12;
        }
        if (n13 > n7) {
            n7 = n13;
        }
        return n7;
    }

    public void c(EnumSkyBlock enumSkyBlock, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        if (!this.areChunksLoaded(n, n2, n3, 17)) {
            return;
        }
        int n12 = 0;
        int n13 = 0;
        this.methodProfiler.a("getBrightness");
        int n14 = this.b(enumSkyBlock, n, n2, n3);
        int n15 = 0;
        int n16 = this.getTypeId(n, n2, n3);
        int n17 = this.b(n, n2, n3);
        if (n17 == 0) {
            n17 = 1;
        }
        int n18 = 0;
        n18 = enumSkyBlock == EnumSkyBlock.SKY ? this.a(n14, n, n2, n3, n16, n17) : this.f(n14, n, n2, n3, n16, n17);
        n15 = n18;
        if (n15 > n14) {
            this.J[n13++] = 133152;
        } else if (n15 < n14) {
            if (enumSkyBlock != EnumSkyBlock.BLOCK) {
                // empty if block
            }
            this.J[n13++] = 133152 + (n14 << 18);
            while (n12 < n13) {
                n16 = this.J[n12++];
                n17 = (n16 & 0x3F) - 32 + n;
                n18 = (n16 >> 6 & 0x3F) - 32 + n2;
                n11 = (n16 >> 12 & 0x3F) - 32 + n3;
                n10 = n16 >> 18 & 0xF;
                n9 = this.b(enumSkyBlock, n17, n18, n11);
                if (n9 != n10) continue;
                this.b(enumSkyBlock, n17, n18, n11, 0);
                if (n10 <= 0) continue;
                n8 = n17 - n;
                n7 = n18 - n2;
                n6 = n11 - n3;
                if (n8 < 0) {
                    n8 = -n8;
                }
                if (n7 < 0) {
                    n7 = -n7;
                }
                if (n6 < 0) {
                    n6 = -n6;
                }
                if (n8 + n7 + n6 >= 17) continue;
                for (n5 = 0; n5 < 6; ++n5) {
                    n4 = n5 % 2 * 2 - 1;
                    int n19 = n17 + n5 / 2 % 3 / 2 * n4;
                    int n20 = n18 + (n5 / 2 + 1) % 3 / 2 * n4;
                    int n21 = n11 + (n5 / 2 + 2) % 3 / 2 * n4;
                    n9 = this.b(enumSkyBlock, n19, n20, n21);
                    int n22 = Block.lightBlock[this.getTypeId(n19, n20, n21)];
                    if (n22 == 0) {
                        n22 = 1;
                    }
                    if (n9 != n10 - n22 || n13 >= this.J.length) continue;
                    this.J[n13++] = n19 - n + 32 + (n20 - n2 + 32 << 6) + (n21 - n3 + 32 << 12) + (n10 - n22 << 18);
                }
            }
            n12 = 0;
        }
        this.methodProfiler.b();
        this.methodProfiler.a("tcp < tcc");
        while (n12 < n13) {
            n16 = this.J[n12++];
            n17 = (n16 & 0x3F) - 32 + n;
            n18 = (n16 >> 6 & 0x3F) - 32 + n2;
            n11 = (n16 >> 12 & 0x3F) - 32 + n3;
            n10 = this.b(enumSkyBlock, n17, n18, n11);
            n9 = this.getTypeId(n17, n18, n11);
            n8 = Block.lightBlock[n9];
            if (n8 == 0) {
                n8 = 1;
            }
            n7 = 0;
            n7 = enumSkyBlock == EnumSkyBlock.SKY ? this.a(n10, n17, n18, n11, n9, n8) : this.f(n10, n17, n18, n11, n9, n8);
            if (n7 == n10) continue;
            this.b(enumSkyBlock, n17, n18, n11, n7);
            if (n7 <= n10) continue;
            n6 = n17 - n;
            n5 = n18 - n2;
            n4 = n11 - n3;
            if (n6 < 0) {
                n6 = -n6;
            }
            if (n5 < 0) {
                n5 = -n5;
            }
            if (n4 < 0) {
                n4 = -n4;
            }
            if (n6 + n5 + n4 >= 17 || n13 >= this.J.length - 6) continue;
            if (this.b(enumSkyBlock, n17 - 1, n18, n11) < n7) {
                this.J[n13++] = n17 - 1 - n + 32 + (n18 - n2 + 32 << 6) + (n11 - n3 + 32 << 12);
            }
            if (this.b(enumSkyBlock, n17 + 1, n18, n11) < n7) {
                this.J[n13++] = n17 + 1 - n + 32 + (n18 - n2 + 32 << 6) + (n11 - n3 + 32 << 12);
            }
            if (this.b(enumSkyBlock, n17, n18 - 1, n11) < n7) {
                this.J[n13++] = n17 - n + 32 + (n18 - 1 - n2 + 32 << 6) + (n11 - n3 + 32 << 12);
            }
            if (this.b(enumSkyBlock, n17, n18 + 1, n11) < n7) {
                this.J[n13++] = n17 - n + 32 + (n18 + 1 - n2 + 32 << 6) + (n11 - n3 + 32 << 12);
            }
            if (this.b(enumSkyBlock, n17, n18, n11 - 1) < n7) {
                this.J[n13++] = n17 - n + 32 + (n18 - n2 + 32 << 6) + (n11 - 1 - n3 + 32 << 12);
            }
            if (this.b(enumSkyBlock, n17, n18, n11 + 1) >= n7) continue;
            this.J[n13++] = n17 - n + 32 + (n18 - n2 + 32 << 6) + (n11 + 1 - n3 + 32 << 12);
        }
        this.methodProfiler.b();
    }

    public boolean a(boolean bl) {
        return false;
    }

    public List a(Chunk chunk, boolean bl) {
        return null;
    }

    public List getEntities(Entity entity, AxisAlignedBB axisAlignedBB) {
        this.N.clear();
        int n = MathHelper.floor((axisAlignedBB.a - 2.0) / 16.0);
        int n2 = MathHelper.floor((axisAlignedBB.d + 2.0) / 16.0);
        int n3 = MathHelper.floor((axisAlignedBB.c - 2.0) / 16.0);
        int n4 = MathHelper.floor((axisAlignedBB.f + 2.0) / 16.0);
        for (int i = n; i <= n2; ++i) {
            for (int j = n3; j <= n4; ++j) {
                if (!this.isChunkLoaded(i, j)) continue;
                this.getChunkAt(i, j).a(entity, axisAlignedBB, this.N);
            }
        }
        return this.N;
    }

    public List a(Class clazz, AxisAlignedBB axisAlignedBB) {
        int n = MathHelper.floor((axisAlignedBB.a - 2.0) / 16.0);
        int n2 = MathHelper.floor((axisAlignedBB.d + 2.0) / 16.0);
        int n3 = MathHelper.floor((axisAlignedBB.c - 2.0) / 16.0);
        int n4 = MathHelper.floor((axisAlignedBB.f + 2.0) / 16.0);
        ArrayList arrayList = new ArrayList();
        for (int i = n; i <= n2; ++i) {
            for (int j = n3; j <= n4; ++j) {
                if (!this.isChunkLoaded(i, j)) continue;
                this.getChunkAt(i, j).a(clazz, axisAlignedBB, arrayList);
            }
        }
        return arrayList;
    }

    public Entity a(Class clazz, AxisAlignedBB axisAlignedBB, Entity entity) {
        List list = this.a(clazz, axisAlignedBB);
        Entity entity2 = null;
        double d = Double.MAX_VALUE;
        for (Entity entity3 : list) {
            double d2;
            if (entity3 == entity || (d2 = entity.e(entity3)) > d) continue;
            entity2 = entity3;
            d = d2;
        }
        return entity2;
    }

    public void b(int n, int n2, int n3, TileEntity tileEntity) {
        if (this.isLoaded(n, n2, n3)) {
            this.getChunkAtWorldCoords(n, n3).e();
        }
    }

    public int a(Class clazz) {
        int n = 0;
        for (int i = 0; i < this.entityList.size(); ++i) {
            Entity entity = (Entity)this.entityList.get(i);
            if (!clazz.isAssignableFrom(entity.getClass())) continue;
            ++n;
        }
        return n;
    }

    public void a(List list) {
        this.entityList.addAll(list);
        for (int i = 0; i < list.size(); ++i) {
            this.a((Entity)list.get(i));
        }
    }

    public void b(List list) {
        this.g.addAll(list);
    }

    public boolean mayPlace(int n, int n2, int n3, int n4, boolean bl, int n5, Entity entity) {
        int n6 = this.getTypeId(n2, n3, n4);
        Block block = Block.byId[n6];
        Block block2 = Block.byId[n];
        AxisAlignedBB axisAlignedBB = block2.e(this, n2, n3, n4);
        if (bl) {
            axisAlignedBB = null;
        }
        if (axisAlignedBB != null && !this.a(axisAlignedBB, entity)) {
            return false;
        }
        if (block != null && (block == Block.WATER || block == Block.STATIONARY_WATER || block == Block.LAVA || block == Block.STATIONARY_LAVA || block == Block.FIRE || block.material.isReplaceable())) {
            block = null;
        }
        return n > 0 && block == null && block2.canPlace(this, n2, n3, n4, n5);
    }

    public PathEntity findPath(Entity entity, Entity entity2, float f, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.methodProfiler.a("pathfind");
        int n = MathHelper.floor(entity.locX);
        int n2 = MathHelper.floor(entity.locY + 1.0);
        int n3 = MathHelper.floor(entity.locZ);
        int n4 = (int)(f + 16.0f);
        int n5 = n - n4;
        int n6 = n2 - n4;
        int n7 = n3 - n4;
        int n8 = n + n4;
        int n9 = n2 + n4;
        int n10 = n3 + n4;
        ChunkCache chunkCache = new ChunkCache(this, n5, n6, n7, n8, n9, n10);
        PathEntity pathEntity = new Pathfinder(chunkCache, bl, bl2, bl3, bl4).a(entity, entity2, f);
        this.methodProfiler.b();
        return pathEntity;
    }

    public PathEntity a(Entity entity, int n, int n2, int n3, float f, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.methodProfiler.a("pathfind");
        int n4 = MathHelper.floor(entity.locX);
        int n5 = MathHelper.floor(entity.locY);
        int n6 = MathHelper.floor(entity.locZ);
        int n7 = (int)(f + 8.0f);
        int n8 = n4 - n7;
        int n9 = n5 - n7;
        int n10 = n6 - n7;
        int n11 = n4 + n7;
        int n12 = n5 + n7;
        int n13 = n6 + n7;
        ChunkCache chunkCache = new ChunkCache(this, n8, n9, n10, n11, n12, n13);
        PathEntity pathEntity = new Pathfinder(chunkCache, bl, bl2, bl3, bl4).a(entity, n, n2, n3, f);
        this.methodProfiler.b();
        return pathEntity;
    }

    public boolean isBlockFacePowered(int n, int n2, int n3, int n4) {
        int n5 = this.getTypeId(n, n2, n3);
        if (n5 == 0) {
            return false;
        }
        return Block.byId[n5].c(this, n, n2, n3, n4);
    }

    public boolean isBlockPowered(int n, int n2, int n3) {
        if (this.isBlockFacePowered(n, n2 - 1, n3, 0)) {
            return true;
        }
        if (this.isBlockFacePowered(n, n2 + 1, n3, 1)) {
            return true;
        }
        if (this.isBlockFacePowered(n, n2, n3 - 1, 2)) {
            return true;
        }
        if (this.isBlockFacePowered(n, n2, n3 + 1, 3)) {
            return true;
        }
        if (this.isBlockFacePowered(n - 1, n2, n3, 4)) {
            return true;
        }
        return this.isBlockFacePowered(n + 1, n2, n3, 5);
    }

    public boolean isBlockFaceIndirectlyPowered(int n, int n2, int n3, int n4) {
        if (this.s(n, n2, n3)) {
            return this.isBlockPowered(n, n2, n3);
        }
        int n5 = this.getTypeId(n, n2, n3);
        if (n5 == 0) {
            return false;
        }
        return Block.byId[n5].a((IBlockAccess)this, n, n2, n3, n4);
    }

    public boolean isBlockIndirectlyPowered(int n, int n2, int n3) {
        if (this.isBlockFaceIndirectlyPowered(n, n2 - 1, n3, 0)) {
            return true;
        }
        if (this.isBlockFaceIndirectlyPowered(n, n2 + 1, n3, 1)) {
            return true;
        }
        if (this.isBlockFaceIndirectlyPowered(n, n2, n3 - 1, 2)) {
            return true;
        }
        if (this.isBlockFaceIndirectlyPowered(n, n2, n3 + 1, 3)) {
            return true;
        }
        if (this.isBlockFaceIndirectlyPowered(n - 1, n2, n3, 4)) {
            return true;
        }
        return this.isBlockFaceIndirectlyPowered(n + 1, n2, n3, 5);
    }

    public EntityHuman findNearbyPlayer(Entity entity, double d) {
        return this.findNearbyPlayer(entity.locX, entity.locY, entity.locZ, d);
    }

    public EntityHuman findNearbyPlayer(double d, double d2, double d3, double d4) {
        double d5 = -1.0;
        EntityHuman entityHuman = null;
        for (int i = 0; i < this.players.size(); ++i) {
            EntityHuman entityHuman2 = (EntityHuman)this.players.get(i);
            double d6 = entityHuman2.e(d, d2, d3);
            if (!(d4 < 0.0) && !(d6 < d4 * d4) || d5 != -1.0 && !(d6 < d5)) continue;
            d5 = d6;
            entityHuman = entityHuman2;
        }
        return entityHuman;
    }

    public EntityHuman findNearbyVulnerablePlayer(Entity entity, double d) {
        return this.findNearbyVulnerablePlayer(entity.locX, entity.locY, entity.locZ, d);
    }

    public EntityHuman findNearbyVulnerablePlayer(double d, double d2, double d3, double d4) {
        double d5 = -1.0;
        EntityHuman entityHuman = null;
        for (int i = 0; i < this.players.size(); ++i) {
            EntityHuman entityHuman2 = (EntityHuman)this.players.get(i);
            if (entityHuman2.abilities.isInvulnerable) continue;
            double d6 = entityHuman2.e(d, d2, d3);
            if (!(d4 < 0.0) && !(d6 < d4 * d4) || d5 != -1.0 && !(d6 < d5)) continue;
            d5 = d6;
            entityHuman = entityHuman2;
        }
        return entityHuman;
    }

    public EntityHuman a(String string) {
        for (int i = 0; i < this.players.size(); ++i) {
            if (!string.equals(((EntityHuman)this.players.get((int)i)).name)) continue;
            return (EntityHuman)this.players.get(i);
        }
        return null;
    }

    public void B() {
        this.dataManager.checkSession();
    }

    public void setTime(long l) {
        this.worldData.b(l);
    }

    public long getSeed() {
        return this.worldData.getSeed();
    }

    public long getTime() {
        return this.worldData.getTime();
    }

    public ChunkCoordinates getSpawn() {
        return new ChunkCoordinates(this.worldData.c(), this.worldData.d(), this.worldData.e());
    }

    public boolean a(EntityHuman entityHuman, int n, int n2, int n3) {
        return true;
    }

    public void broadcastEntityEffect(Entity entity, byte by) {
    }

    public IChunkProvider F() {
        return this.chunkProvider;
    }

    public void playNote(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n4 > 0) {
            Block.byId[n4].b(this, n, n2, n3, n5, n6);
        }
    }

    public IDataManager getDataManager() {
        return this.dataManager;
    }

    public WorldData getWorldData() {
        return this.worldData;
    }

    public void everyoneSleeping() {
    }

    public float i(float f) {
        return (this.p + (this.q - this.p) * f) * this.j(f);
    }

    public float j(float f) {
        return this.n + (this.o - this.n) * f;
    }

    public boolean I() {
        return (double)this.i(1.0f) > 0.9;
    }

    public boolean J() {
        return (double)this.j(1.0f) > 0.2;
    }

    public boolean B(int n, int n2, int n3) {
        if (!this.J()) {
            return false;
        }
        if (!this.j(n, n2, n3)) {
            return false;
        }
        if (this.g(n, n3) > n2) {
            return false;
        }
        BiomeBase biomeBase = this.getBiome(n, n3);
        if (biomeBase.c()) {
            return false;
        }
        return biomeBase.d();
    }

    public boolean C(int n, int n2, int n3) {
        BiomeBase biomeBase = this.getBiome(n, n3);
        return biomeBase.e();
    }

    public void a(String string, WorldMapBase worldMapBase) {
        this.worldMaps.a(string, worldMapBase);
    }

    public WorldMapBase a(Class clazz, String string) {
        return this.worldMaps.get(clazz, string);
    }

    public int b(String string) {
        return this.worldMaps.a(string);
    }

    public void triggerEffect(int n, int n2, int n3, int n4, int n5) {
        this.a(null, n, n2, n3, n4, n5);
    }

    public void a(EntityHuman entityHuman, int n, int n2, int n3, int n4, int n5) {
        for (int i = 0; i < this.x.size(); ++i) {
            ((IWorldAccess)this.x.get(i)).a(entityHuman, n, n2, n3, n4, n5);
        }
    }

    public int getHeight() {
        return 256;
    }

    public int L() {
        return this.worldProvider.e ? 128 : 256;
    }

    public Random D(int n, int n2, int n3) {
        long l = (long)n * 341873128712L + (long)n2 * 132897987541L + this.getWorldData().getSeed() + (long)n3;
        this.random.setSeed(l);
        return this.random;
    }

    public boolean updateLights() {
        return false;
    }

    public ChunkPosition b(String string, int n, int n2, int n3) {
        return this.F().findNearestMapFeature(this, string, n, n2, n3);
    }

    public CrashReport a(CrashReport crashReport) {
        crashReport.a("World " + this.worldData.getName() + " Entities", new CrashReportEntities(this));
        crashReport.a("World " + this.worldData.getName() + " Players", new CrashReportPlayers(this));
        crashReport.a("World " + this.worldData.getName() + " Chunk Stats", new CrashReportChunkStats(this));
        return crashReport;
    }

    public void f(int n, int n2, int n3, int n4, int n5) {
        for (IWorldAccess iWorldAccess : this.x) {
            iWorldAccess.a(n, n2, n3, n4, n5);
        }
    }
}

