/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.io.File;
import java.net.SocketAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import net.minecraft.server.BanEntry;
import net.minecraft.server.BanList;
import net.minecraft.server.ChunkCoordinates;
import net.minecraft.server.DemoItemInWorldManager;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityPlayer;
import net.minecraft.server.EnumGamemode;
import net.minecraft.server.INetworkManager;
import net.minecraft.server.ItemInWorldManager;
import net.minecraft.server.MathHelper;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.MobEffect;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NetServerHandler;
import net.minecraft.server.Packet;
import net.minecraft.server.Packet1Login;
import net.minecraft.server.Packet201PlayerInfo;
import net.minecraft.server.Packet202Abilities;
import net.minecraft.server.Packet3Chat;
import net.minecraft.server.Packet41MobEffect;
import net.minecraft.server.Packet4UpdateTime;
import net.minecraft.server.Packet6SpawnPosition;
import net.minecraft.server.Packet70Bed;
import net.minecraft.server.Packet9Respawn;
import net.minecraft.server.PlayerFileData;
import net.minecraft.server.PlayerManager;
import net.minecraft.server.PortalTravelAgent;
import net.minecraft.server.World;
import net.minecraft.server.WorldServer;

public abstract class ServerConfigurationManagerAbstract {
    private static final SimpleDateFormat e = new SimpleDateFormat("yyyy-MM-dd 'at' HH:mm:ss z");
    public static final Logger a = Logger.getLogger("Minecraft");
    private final MinecraftServer server;
    public final List players = new ArrayList();
    private final BanList banByName = new BanList(new File("banned-players.txt"));
    private final BanList banByIP = new BanList(new File("banned-ips.txt"));
    private Set operators = new HashSet();
    private Set whitelist = new HashSet();
    private PlayerFileData playerFileData;
    private boolean hasWhitelist;
    protected int maxPlayers;
    protected int d;
    private EnumGamemode m;
    private boolean n;
    private int o = 0;

    public ServerConfigurationManagerAbstract(MinecraftServer minecraftServer) {
        this.server = minecraftServer;
        this.banByName.setEnabled(false);
        this.banByIP.setEnabled(false);
        this.maxPlayers = 8;
    }

    public void a(INetworkManager iNetworkManager, EntityPlayer entityPlayer) {
        this.a(entityPlayer);
        entityPlayer.spawnIn(this.server.getWorldServer(entityPlayer.dimension));
        entityPlayer.itemInWorldManager.a((WorldServer)entityPlayer.world);
        String string = "local";
        if (iNetworkManager.getSocketAddress() != null) {
            string = iNetworkManager.getSocketAddress().toString();
        }
        a.info(entityPlayer.name + "[" + string + "] logged in with entity id " + entityPlayer.id + " at (" + entityPlayer.locX + ", " + entityPlayer.locY + ", " + entityPlayer.locZ + ")");
        WorldServer worldServer = this.server.getWorldServer(entityPlayer.dimension);
        ChunkCoordinates chunkCoordinates = worldServer.getSpawn();
        this.a(entityPlayer, null, worldServer);
        NetServerHandler netServerHandler = new NetServerHandler(this.server, iNetworkManager, entityPlayer);
        netServerHandler.sendPacket(new Packet1Login(entityPlayer.id, worldServer.getWorldData().getType(), entityPlayer.itemInWorldManager.getGameMode(), worldServer.getWorldData().isHardcore(), worldServer.worldProvider.dimension, worldServer.difficulty, worldServer.getHeight(), this.getMaxPlayers()));
        netServerHandler.sendPacket(new Packet6SpawnPosition(chunkCoordinates.x, chunkCoordinates.y, chunkCoordinates.z));
        netServerHandler.sendPacket(new Packet202Abilities(entityPlayer.abilities));
        this.b(entityPlayer, worldServer);
        this.sendAll(new Packet3Chat("\u00a7e" + entityPlayer.name + " joined the game."));
        this.c(entityPlayer);
        netServerHandler.a(entityPlayer.locX, entityPlayer.locY, entityPlayer.locZ, entityPlayer.yaw, entityPlayer.pitch);
        this.server.ac().a(netServerHandler);
        netServerHandler.sendPacket(new Packet4UpdateTime(worldServer.getTime()));
        if (this.server.getTexturePack().length() > 0) {
            entityPlayer.a(this.server.getTexturePack(), this.server.R());
        }
        for (MobEffect mobEffect : entityPlayer.getEffects()) {
            netServerHandler.sendPacket(new Packet41MobEffect(entityPlayer.id, mobEffect));
        }
        entityPlayer.syncInventory();
    }

    public void setPlayerFileData(WorldServer[] worldServerArray) {
        this.playerFileData = worldServerArray[0].getDataManager().getPlayerFileData();
    }

    public void a(EntityPlayer entityPlayer, WorldServer worldServer) {
        WorldServer worldServer2 = entityPlayer.q();
        if (worldServer != null) {
            worldServer.getPlayerManager().removePlayer(entityPlayer);
        }
        worldServer2.getPlayerManager().addPlayer(entityPlayer);
        worldServer2.chunkProviderServer.getChunkAt((int)entityPlayer.locX >> 4, (int)entityPlayer.locZ >> 4);
    }

    public int a() {
        return PlayerManager.getFurthestViewableBlock(this.o());
    }

    public void a(EntityPlayer entityPlayer) {
        NBTTagCompound nBTTagCompound = this.server.worldServer[0].getWorldData().h();
        if (entityPlayer.getName().equals(this.server.G()) && nBTTagCompound != null) {
            entityPlayer.e(nBTTagCompound);
        } else {
            this.playerFileData.load(entityPlayer);
        }
    }

    protected void b(EntityPlayer entityPlayer) {
        this.playerFileData.save(entityPlayer);
    }

    public void c(EntityPlayer entityPlayer) {
        this.sendAll(new Packet201PlayerInfo(entityPlayer.name, true, 1000));
        this.players.add(entityPlayer);
        WorldServer worldServer = this.server.getWorldServer(entityPlayer.dimension);
        while (!worldServer.getCubes(entityPlayer, entityPlayer.boundingBox).isEmpty()) {
            entityPlayer.setPosition(entityPlayer.locX, entityPlayer.locY + 1.0, entityPlayer.locZ);
        }
        worldServer.addEntity(entityPlayer);
        this.a(entityPlayer, null);
        for (EntityPlayer entityPlayer2 : this.players) {
            entityPlayer.netServerHandler.sendPacket(new Packet201PlayerInfo(entityPlayer2.name, true, entityPlayer2.ping));
        }
    }

    public void d(EntityPlayer entityPlayer) {
        entityPlayer.q().getPlayerManager().movePlayer(entityPlayer);
    }

    public void disconnect(EntityPlayer entityPlayer) {
        this.b(entityPlayer);
        WorldServer worldServer = entityPlayer.q();
        worldServer.kill(entityPlayer);
        worldServer.getPlayerManager().removePlayer(entityPlayer);
        this.players.remove(entityPlayer);
        this.sendAll(new Packet201PlayerInfo(entityPlayer.name, false, 9999));
    }

    public String attemptLogin(SocketAddress socketAddress, String string) {
        if (this.banByName.isBanned(string)) {
            BanEntry banEntry = (BanEntry)this.banByName.getEntries().get(string);
            String string2 = "You are banned from this server!\nReason: " + banEntry.getReason();
            if (banEntry.getExpires() != null) {
                string2 = string2 + "\nYour ban will be removed on " + e.format(banEntry.getExpires());
            }
            return string2;
        }
        if (!this.isWhitelisted(string)) {
            return "You are not white-listed on this server!";
        }
        String string3 = socketAddress.toString();
        string3 = string3.substring(string3.indexOf("/") + 1);
        if (this.banByIP.isBanned(string3 = string3.substring(0, string3.indexOf(":")))) {
            BanEntry banEntry = (BanEntry)this.banByIP.getEntries().get(string3);
            String string4 = "Your IP address is banned from this server!\nReason: " + banEntry.getReason();
            if (banEntry.getExpires() != null) {
                string4 = string4 + "\nYour ban will be removed on " + e.format(banEntry.getExpires());
            }
            return string4;
        }
        if (this.players.size() >= this.maxPlayers) {
            return "The server is full!";
        }
        return null;
    }

    public EntityPlayer processLogin(String string) {
        ArrayList<EntityPlayer> arrayList = new ArrayList<EntityPlayer>();
        for (EntityPlayer entityPlayer : this.players) {
            if (!entityPlayer.name.equalsIgnoreCase(string)) continue;
            arrayList.add(entityPlayer);
        }
        for (EntityPlayer entityPlayer : arrayList) {
            entityPlayer.netServerHandler.disconnect("You logged in from another location");
        }
        ItemInWorldManager itemInWorldManager = this.server.L() ? new DemoItemInWorldManager(this.server.getWorldServer(0)) : new ItemInWorldManager(this.server.getWorldServer(0));
        return new EntityPlayer(this.server, this.server.getWorldServer(0), string, itemInWorldManager);
    }

    public EntityPlayer moveToWorld(EntityPlayer entityPlayer, int n, boolean bl) {
        ChunkCoordinates chunkCoordinates;
        entityPlayer.q().getTracker().untrackPlayer(entityPlayer);
        entityPlayer.q().getTracker().untrackEntity(entityPlayer);
        entityPlayer.q().getPlayerManager().removePlayer(entityPlayer);
        this.players.remove(entityPlayer);
        this.server.getWorldServer(entityPlayer.dimension).removeEntity(entityPlayer);
        ChunkCoordinates chunkCoordinates2 = entityPlayer.getBed();
        entityPlayer.dimension = n;
        ItemInWorldManager itemInWorldManager = this.server.L() ? new DemoItemInWorldManager(this.server.getWorldServer(entityPlayer.dimension)) : new ItemInWorldManager(this.server.getWorldServer(entityPlayer.dimension));
        EntityPlayer entityPlayer2 = new EntityPlayer(this.server, this.server.getWorldServer(entityPlayer.dimension), entityPlayer.name, itemInWorldManager);
        entityPlayer2.copyTo(entityPlayer, bl);
        entityPlayer2.id = entityPlayer.id;
        entityPlayer2.netServerHandler = entityPlayer.netServerHandler;
        WorldServer worldServer = this.server.getWorldServer(entityPlayer.dimension);
        this.a(entityPlayer2, entityPlayer, worldServer);
        if (chunkCoordinates2 != null) {
            chunkCoordinates = EntityHuman.getBed(this.server.getWorldServer(entityPlayer.dimension), chunkCoordinates2);
            if (chunkCoordinates != null) {
                entityPlayer2.setPositionRotation((float)chunkCoordinates.x + 0.5f, (float)chunkCoordinates.y + 0.1f, (float)chunkCoordinates.z + 0.5f, 0.0f, 0.0f);
                entityPlayer2.setRespawnPosition(chunkCoordinates2);
            } else {
                entityPlayer2.netServerHandler.sendPacket(new Packet70Bed(0, 0));
            }
        }
        worldServer.chunkProviderServer.getChunkAt((int)entityPlayer2.locX >> 4, (int)entityPlayer2.locZ >> 4);
        while (!worldServer.getCubes(entityPlayer2, entityPlayer2.boundingBox).isEmpty()) {
            entityPlayer2.setPosition(entityPlayer2.locX, entityPlayer2.locY + 1.0, entityPlayer2.locZ);
        }
        entityPlayer2.netServerHandler.sendPacket(new Packet9Respawn(entityPlayer2.dimension, (byte)entityPlayer2.world.difficulty, entityPlayer2.world.getWorldData().getType(), entityPlayer2.world.getHeight(), entityPlayer2.itemInWorldManager.getGameMode()));
        chunkCoordinates = worldServer.getSpawn();
        entityPlayer2.netServerHandler.a(entityPlayer2.locX, entityPlayer2.locY, entityPlayer2.locZ, entityPlayer2.yaw, entityPlayer2.pitch);
        entityPlayer2.netServerHandler.sendPacket(new Packet6SpawnPosition(chunkCoordinates.x, chunkCoordinates.y, chunkCoordinates.z));
        this.b(entityPlayer2, worldServer);
        worldServer.getPlayerManager().addPlayer(entityPlayer2);
        worldServer.addEntity(entityPlayer2);
        this.players.add(entityPlayer2);
        entityPlayer2.syncInventory();
        return entityPlayer2;
    }

    public void changeDimension(EntityPlayer entityPlayer, int n) {
        int n2 = entityPlayer.dimension;
        WorldServer worldServer = this.server.getWorldServer(entityPlayer.dimension);
        entityPlayer.dimension = n;
        WorldServer worldServer2 = this.server.getWorldServer(entityPlayer.dimension);
        entityPlayer.netServerHandler.sendPacket(new Packet9Respawn(entityPlayer.dimension, (byte)entityPlayer.world.difficulty, worldServer2.getWorldData().getType(), worldServer2.getHeight(), entityPlayer.itemInWorldManager.getGameMode()));
        worldServer.removeEntity(entityPlayer);
        entityPlayer.dead = false;
        double d = entityPlayer.locX;
        double d2 = entityPlayer.locZ;
        double d3 = 8.0;
        if (entityPlayer.dimension == -1) {
            entityPlayer.setPositionRotation(d /= d3, entityPlayer.locY, d2 /= d3, entityPlayer.yaw, entityPlayer.pitch);
            if (entityPlayer.isAlive()) {
                worldServer.entityJoinedWorld(entityPlayer, false);
            }
        } else if (entityPlayer.dimension == 0) {
            entityPlayer.setPositionRotation(d *= d3, entityPlayer.locY, d2 *= d3, entityPlayer.yaw, entityPlayer.pitch);
            if (entityPlayer.isAlive()) {
                worldServer.entityJoinedWorld(entityPlayer, false);
            }
        } else {
            ChunkCoordinates chunkCoordinates = worldServer2.getDimensionSpawn();
            d = chunkCoordinates.x;
            entityPlayer.locY = chunkCoordinates.y;
            d2 = chunkCoordinates.z;
            entityPlayer.setPositionRotation(d, entityPlayer.locY, d2, 90.0f, 0.0f);
            if (entityPlayer.isAlive()) {
                worldServer.entityJoinedWorld(entityPlayer, false);
            }
        }
        if (n2 != 1) {
            d = MathHelper.a((int)d, -29999872, 29999872);
            d2 = MathHelper.a((int)d2, -29999872, 29999872);
            if (entityPlayer.isAlive()) {
                worldServer2.addEntity(entityPlayer);
                entityPlayer.setPositionRotation(d, entityPlayer.locY, d2, entityPlayer.yaw, entityPlayer.pitch);
                worldServer2.entityJoinedWorld(entityPlayer, false);
                new PortalTravelAgent().a(worldServer2, entityPlayer);
            }
        }
        entityPlayer.spawnIn(worldServer2);
        this.a(entityPlayer, worldServer);
        entityPlayer.netServerHandler.a(entityPlayer.locX, entityPlayer.locY, entityPlayer.locZ, entityPlayer.yaw, entityPlayer.pitch);
        entityPlayer.itemInWorldManager.a(worldServer2);
        this.b(entityPlayer, worldServer2);
        this.updateClient(entityPlayer);
        for (MobEffect mobEffect : entityPlayer.getEffects()) {
            entityPlayer.netServerHandler.sendPacket(new Packet41MobEffect(entityPlayer.id, mobEffect));
        }
    }

    public void tick() {
        if (++this.o > 600) {
            this.o = 0;
        }
        if (this.o < this.players.size()) {
            EntityPlayer entityPlayer = (EntityPlayer)this.players.get(this.o);
            this.sendAll(new Packet201PlayerInfo(entityPlayer.name, true, entityPlayer.ping));
        }
    }

    public void sendAll(Packet packet) {
        for (int i = 0; i < this.players.size(); ++i) {
            ((EntityPlayer)this.players.get((int)i)).netServerHandler.sendPacket(packet);
        }
    }

    public void a(Packet packet, int n) {
        for (EntityPlayer entityPlayer : this.players) {
            if (entityPlayer.dimension != n) continue;
            entityPlayer.netServerHandler.sendPacket(packet);
        }
    }

    public String c() {
        String string = "";
        for (int i = 0; i < this.players.size(); ++i) {
            if (i > 0) {
                string = string + ", ";
            }
            string = string + ((EntityPlayer)this.players.get((int)i)).name;
        }
        return string;
    }

    public String[] d() {
        String[] stringArray = new String[this.players.size()];
        for (int i = 0; i < this.players.size(); ++i) {
            stringArray[i] = ((EntityPlayer)this.players.get((int)i)).name;
        }
        return stringArray;
    }

    public BanList getNameBans() {
        return this.banByName;
    }

    public BanList getIPBans() {
        return this.banByIP;
    }

    public void addOp(String string) {
        this.operators.add(string.toLowerCase());
    }

    public void removeOp(String string) {
        this.operators.remove(string.toLowerCase());
    }

    public boolean isWhitelisted(String string) {
        string = string.trim().toLowerCase();
        return !this.hasWhitelist || this.operators.contains(string) || this.whitelist.contains(string);
    }

    public boolean isOp(String string) {
        return this.operators.contains(string.trim().toLowerCase()) || this.server.H() && this.server.worldServer[0].getWorldData().allowCommands() && this.server.G().equalsIgnoreCase(string) || this.n;
    }

    public EntityPlayer f(String string) {
        for (EntityPlayer entityPlayer : this.players) {
            if (!entityPlayer.name.equalsIgnoreCase(string)) continue;
            return entityPlayer;
        }
        return null;
    }

    public void sendPacketNearby(double d, double d2, double d3, double d4, int n, Packet packet) {
        this.sendPacketNearby(null, d, d2, d3, d4, n, packet);
    }

    public void sendPacketNearby(EntityHuman entityHuman, double d, double d2, double d3, double d4, int n, Packet packet) {
        for (EntityPlayer entityPlayer : this.players) {
            double d5;
            double d6;
            double d7;
            if (entityPlayer == entityHuman || entityPlayer.dimension != n || !((d7 = d - entityPlayer.locX) * d7 + (d6 = d2 - entityPlayer.locY) * d6 + (d5 = d3 - entityPlayer.locZ) * d5 < d4 * d4)) continue;
            entityPlayer.netServerHandler.sendPacket(packet);
        }
    }

    public void savePlayers() {
        for (EntityPlayer entityPlayer : this.players) {
            this.b(entityPlayer);
        }
    }

    public void addWhitelist(String string) {
        this.whitelist.add(string);
    }

    public void removeWhitelist(String string) {
        this.whitelist.remove(string);
    }

    public Set getWhitelisted() {
        return this.whitelist;
    }

    public Set getOPs() {
        return this.operators;
    }

    public void reloadWhitelist() {
    }

    public void b(EntityPlayer entityPlayer, WorldServer worldServer) {
        entityPlayer.netServerHandler.sendPacket(new Packet4UpdateTime(worldServer.getTime()));
        if (worldServer.J()) {
            entityPlayer.netServerHandler.sendPacket(new Packet70Bed(1, 0));
        }
    }

    public void updateClient(EntityPlayer entityPlayer) {
        entityPlayer.updateInventory(entityPlayer.defaultContainer);
        entityPlayer.n();
    }

    public int getPlayerCount() {
        return this.players.size();
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    public String[] getSeenPlayers() {
        return this.server.worldServer[0].getDataManager().getPlayerFileData().getSeenPlayers();
    }

    public boolean getHasWhitelist() {
        return this.hasWhitelist;
    }

    public void setHasWhitelist(boolean bl) {
        this.hasWhitelist = bl;
    }

    public List j(String string) {
        ArrayList<EntityPlayer> arrayList = new ArrayList<EntityPlayer>();
        for (EntityPlayer entityPlayer : this.players) {
            if (!entityPlayer.r().equals(string)) continue;
            arrayList.add(entityPlayer);
        }
        return arrayList;
    }

    public int o() {
        return this.d;
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    public NBTTagCompound q() {
        return null;
    }

    private void a(EntityPlayer entityPlayer, EntityPlayer entityPlayer2, World world) {
        if (entityPlayer2 != null) {
            entityPlayer.itemInWorldManager.setGameMode(entityPlayer2.itemInWorldManager.getGameMode());
        } else if (this.m != null) {
            entityPlayer.itemInWorldManager.setGameMode(this.m);
        }
        entityPlayer.itemInWorldManager.b(world.getWorldData().getGameType());
    }

    public void r() {
        while (!this.players.isEmpty()) {
            ((EntityPlayer)this.players.get((int)0)).netServerHandler.disconnect("Server closed");
        }
    }
}

