/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityAnimal;
import net.minecraft.server.EntityArrow;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntitySheep;
import net.minecraft.server.EntityTameableAnimal;
import net.minecraft.server.Item;
import net.minecraft.server.ItemFood;
import net.minecraft.server.ItemStack;
import net.minecraft.server.MathHelper;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.PathfinderGoalBeg;
import net.minecraft.server.PathfinderGoalBreed;
import net.minecraft.server.PathfinderGoalFloat;
import net.minecraft.server.PathfinderGoalFollowOwner;
import net.minecraft.server.PathfinderGoalHurtByTarget;
import net.minecraft.server.PathfinderGoalLeapAtTarget;
import net.minecraft.server.PathfinderGoalLookAtPlayer;
import net.minecraft.server.PathfinderGoalMeleeAttack;
import net.minecraft.server.PathfinderGoalOwnerHurtByTarget;
import net.minecraft.server.PathfinderGoalOwnerHurtTarget;
import net.minecraft.server.PathfinderGoalRandomLookaround;
import net.minecraft.server.PathfinderGoalRandomStroll;
import net.minecraft.server.PathfinderGoalRandomTargetNonTamed;
import net.minecraft.server.World;

public class EntityWolf
extends EntityTameableAnimal {
    private float e;
    private float f;
    private boolean g;
    private boolean h;
    private float i;
    private float j;

    public EntityWolf(World world) {
        super(world);
        this.texture = "/mob/wolf.png";
        this.a(0.6f, 0.8f);
        this.bw = 0.3f;
        this.getNavigation().a(true);
        this.goalSelector.a(1, new PathfinderGoalFloat(this));
        this.goalSelector.a(2, this.d);
        this.goalSelector.a(3, new PathfinderGoalLeapAtTarget(this, 0.4f));
        this.goalSelector.a(4, new PathfinderGoalMeleeAttack(this, this.bw, true));
        this.goalSelector.a(5, new PathfinderGoalFollowOwner(this, this.bw, 10.0f, 2.0f));
        this.goalSelector.a(6, new PathfinderGoalBreed(this, this.bw));
        this.goalSelector.a(7, new PathfinderGoalRandomStroll(this, this.bw));
        this.goalSelector.a(8, new PathfinderGoalBeg(this, 8.0f));
        this.goalSelector.a(9, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.goalSelector.a(9, new PathfinderGoalRandomLookaround(this));
        this.targetSelector.a(1, new PathfinderGoalOwnerHurtByTarget(this));
        this.targetSelector.a(2, new PathfinderGoalOwnerHurtTarget(this));
        this.targetSelector.a(3, new PathfinderGoalHurtByTarget(this, true));
        this.targetSelector.a(4, new PathfinderGoalRandomTargetNonTamed(this, EntitySheep.class, 16.0f, 200, false));
    }

    public boolean aV() {
        return true;
    }

    public void b(EntityLiving entityLiving) {
        super.b(entityLiving);
        if (entityLiving instanceof EntityHuman) {
            this.setAngry(true);
        }
    }

    protected void bd() {
        this.datawatcher.watch(18, this.getHealth());
    }

    public int getMaxHealth() {
        if (this.isTamed()) {
            return 20;
        }
        return 8;
    }

    protected void a() {
        super.a();
        this.datawatcher.a(18, new Integer(this.getHealth()));
        this.datawatcher.a(19, new Byte(0));
    }

    protected boolean e_() {
        return false;
    }

    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        nBTTagCompound.setBoolean("Angry", this.isAngry());
    }

    public void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        this.setAngry(nBTTagCompound.getBoolean("Angry"));
    }

    protected boolean ba() {
        return this.isAngry();
    }

    protected String aQ() {
        if (this.isAngry()) {
            return "mob.wolf.growl";
        }
        if (this.random.nextInt(3) == 0) {
            if (this.isTamed() && this.datawatcher.getInt(18) < 10) {
                return "mob.wolf.whine";
            }
            return "mob.wolf.panting";
        }
        return "mob.wolf.bark";
    }

    protected String aR() {
        return "mob.wolf.hurt";
    }

    protected String aS() {
        return "mob.wolf.death";
    }

    protected float aP() {
        return 0.4f;
    }

    protected int getLootId() {
        return -1;
    }

    public void d() {
        super.d();
        if (!this.world.isStatic && this.g && !this.h && !this.l() && this.onGround) {
            this.h = true;
            this.i = 0.0f;
            this.j = 0.0f;
            this.world.broadcastEntityEffect(this, (byte)8);
        }
    }

    public void h_() {
        super.h_();
        this.f = this.e;
        this.e = this.bv() ? (this.e += (1.0f - this.e) * 0.4f) : (this.e += (0.0f - this.e) * 0.4f);
        if (this.bv()) {
            this.bx = 10;
        }
        if (this.G()) {
            this.g = true;
            this.h = false;
            this.i = 0.0f;
            this.j = 0.0f;
        } else if ((this.g || this.h) && this.h) {
            if (this.i == 0.0f) {
                this.world.makeSound(this, "mob.wolf.shake", this.aP(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            }
            this.j = this.i;
            this.i += 0.05f;
            if (this.j >= 2.0f) {
                this.g = false;
                this.h = false;
                this.j = 0.0f;
                this.i = 0.0f;
            }
            if (this.i > 0.4f) {
                float f = (float)this.boundingBox.b;
                int n = (int)(MathHelper.sin((this.i - 0.4f) * (float)Math.PI) * 7.0f);
                for (int i = 0; i < n; ++i) {
                    float f2 = (this.random.nextFloat() * 2.0f - 1.0f) * this.width * 0.5f;
                    float f3 = (this.random.nextFloat() * 2.0f - 1.0f) * this.width * 0.5f;
                    this.world.a("splash", this.locX + (double)f2, f + 0.8f, this.locZ + (double)f3, this.motX, this.motY, this.motZ);
                }
            }
        }
    }

    public float getHeadHeight() {
        return this.length * 0.8f;
    }

    public int bf() {
        if (this.isSitting()) {
            return 20;
        }
        return super.bf();
    }

    public boolean damageEntity(DamageSource damageSource, int n) {
        Entity entity = damageSource.getEntity();
        this.d.a(false);
        if (entity != null && !(entity instanceof EntityHuman) && !(entity instanceof EntityArrow)) {
            n = (n + 1) / 2;
        }
        return super.damageEntity(damageSource, n);
    }

    public boolean k(Entity entity) {
        int n = this.isTamed() ? 4 : 2;
        return entity.damageEntity(DamageSource.mobAttack(this), n);
    }

    public boolean c(EntityHuman entityHuman) {
        ItemStack itemStack = entityHuman.inventory.getItemInHand();
        if (this.isTamed()) {
            ItemFood itemFood;
            if (itemStack != null && Item.byId[itemStack.id] instanceof ItemFood && (itemFood = (ItemFood)Item.byId[itemStack.id]).h() && this.datawatcher.getInt(18) < 20) {
                if (!entityHuman.abilities.canInstantlyBuild) {
                    --itemStack.count;
                }
                this.heal(itemFood.getNutrition());
                if (itemStack.count <= 0) {
                    entityHuman.inventory.setItem(entityHuman.inventory.itemInHandIndex, null);
                }
                return true;
            }
            if (entityHuman.name.equalsIgnoreCase(this.getOwnerName()) && !this.world.isStatic && !this.b(itemStack)) {
                this.d.a(!this.isSitting());
                this.bu = false;
                this.setPathEntity(null);
            }
        } else if (itemStack != null && itemStack.id == Item.BONE.id && !this.isAngry()) {
            if (!entityHuman.abilities.canInstantlyBuild) {
                --itemStack.count;
            }
            if (itemStack.count <= 0) {
                entityHuman.inventory.setItem(entityHuman.inventory.itemInHandIndex, null);
            }
            if (!this.world.isStatic) {
                if (this.random.nextInt(3) == 0) {
                    this.setTamed(true);
                    this.setPathEntity(null);
                    this.b((EntityLiving)null);
                    this.d.a(true);
                    this.setHealth(20);
                    this.setOwnerName(entityHuman.name);
                    this.e(true);
                    this.world.broadcastEntityEffect(this, (byte)7);
                } else {
                    this.e(false);
                    this.world.broadcastEntityEffect(this, (byte)6);
                }
            }
            return true;
        }
        return super.c(entityHuman);
    }

    public boolean b(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        if (!(Item.byId[itemStack.id] instanceof ItemFood)) {
            return false;
        }
        return ((ItemFood)Item.byId[itemStack.id]).h();
    }

    public int bl() {
        return 8;
    }

    public boolean isAngry() {
        return (this.datawatcher.getByte(16) & 2) != 0;
    }

    public void setAngry(boolean bl) {
        byte by = this.datawatcher.getByte(16);
        if (bl) {
            this.datawatcher.watch(16, (byte)(by | 2));
        } else {
            this.datawatcher.watch(16, (byte)(by & 0xFFFFFFFD));
        }
    }

    public EntityAnimal createChild(EntityAnimal entityAnimal) {
        EntityWolf entityWolf = new EntityWolf(this.world);
        entityWolf.setOwnerName(this.getOwnerName());
        entityWolf.setTamed(true);
        return entityWolf;
    }

    public void i(boolean bl) {
        byte by = this.datawatcher.getByte(19);
        if (bl) {
            this.datawatcher.watch(19, (byte)1);
        } else {
            this.datawatcher.watch(19, (byte)0);
        }
    }

    public boolean mate(EntityAnimal entityAnimal) {
        if (entityAnimal == this) {
            return false;
        }
        if (!this.isTamed()) {
            return false;
        }
        if (!(entityAnimal instanceof EntityWolf)) {
            return false;
        }
        EntityWolf entityWolf = (EntityWolf)entityAnimal;
        if (!entityWolf.isTamed()) {
            return false;
        }
        if (entityWolf.isSitting()) {
            return false;
        }
        return this.s() && entityWolf.s();
    }

    public boolean bv() {
        return this.datawatcher.getByte(19) == 1;
    }
}

