/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.Random;
import net.minecraft.server.Block;
import net.minecraft.server.EntityAnimal;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityItem;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.PathfinderGoalBreed;
import net.minecraft.server.PathfinderGoalEatTile;
import net.minecraft.server.PathfinderGoalFloat;
import net.minecraft.server.PathfinderGoalFollowParent;
import net.minecraft.server.PathfinderGoalLookAtPlayer;
import net.minecraft.server.PathfinderGoalPanic;
import net.minecraft.server.PathfinderGoalRandomLookaround;
import net.minecraft.server.PathfinderGoalRandomStroll;
import net.minecraft.server.PathfinderGoalTempt;
import net.minecraft.server.World;

public class EntitySheep
extends EntityAnimal {
    public static final float[][] d = new float[][]{{1.0f, 1.0f, 1.0f}, {0.95f, 0.7f, 0.2f}, {0.9f, 0.5f, 0.85f}, {0.6f, 0.7f, 0.95f}, {0.9f, 0.9f, 0.2f}, {0.5f, 0.8f, 0.1f}, {0.95f, 0.7f, 0.8f}, {0.3f, 0.3f, 0.3f}, {0.6f, 0.6f, 0.6f}, {0.3f, 0.6f, 0.7f}, {0.7f, 0.4f, 0.9f}, {0.2f, 0.4f, 0.8f}, {0.5f, 0.4f, 0.3f}, {0.4f, 0.5f, 0.2f}, {0.8f, 0.3f, 0.3f}, {0.1f, 0.1f, 0.1f}};
    private int e;
    private PathfinderGoalEatTile f = new PathfinderGoalEatTile(this);

    public EntitySheep(World world) {
        super(world);
        this.texture = "/mob/sheep.png";
        this.a(0.9f, 1.3f);
        float f = 0.23f;
        this.getNavigation().a(true);
        this.goalSelector.a(0, new PathfinderGoalFloat(this));
        this.goalSelector.a(1, new PathfinderGoalPanic(this, 0.38f));
        this.goalSelector.a(2, new PathfinderGoalBreed(this, f));
        this.goalSelector.a(3, new PathfinderGoalTempt(this, 0.25f, Item.WHEAT.id, false));
        this.goalSelector.a(4, new PathfinderGoalFollowParent(this, 0.25f));
        this.goalSelector.a(5, this.f);
        this.goalSelector.a(6, new PathfinderGoalRandomStroll(this, f));
        this.goalSelector.a(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.goalSelector.a(8, new PathfinderGoalRandomLookaround(this));
    }

    protected boolean aV() {
        return true;
    }

    protected void bc() {
        this.e = this.f.f();
        super.bc();
    }

    public void d() {
        if (this.world.isStatic) {
            this.e = Math.max(0, this.e - 1);
        }
        super.d();
    }

    public int getMaxHealth() {
        return 8;
    }

    protected void a() {
        super.a();
        this.datawatcher.a(16, new Byte(0));
    }

    protected void dropDeathLoot(boolean bl, int n) {
        if (!this.isSheared()) {
            this.a(new ItemStack(Block.WOOL.id, 1, this.getColor()), 0.0f);
        }
    }

    protected int getLootId() {
        return Block.WOOL.id;
    }

    public boolean c(EntityHuman entityHuman) {
        ItemStack itemStack = entityHuman.inventory.getItemInHand();
        if (itemStack != null && itemStack.id == Item.SHEARS.id && !this.isSheared() && !this.isBaby()) {
            if (!this.world.isStatic) {
                this.setSheared(true);
                int n = 1 + this.random.nextInt(3);
                for (int i = 0; i < n; ++i) {
                    EntityItem entityItem = this.a(new ItemStack(Block.WOOL.id, 1, this.getColor()), 1.0f);
                    entityItem.motY += (double)(this.random.nextFloat() * 0.05f);
                    entityItem.motX += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f);
                    entityItem.motZ += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f);
                }
            }
            itemStack.damage(1, entityHuman);
        }
        return super.c(entityHuman);
    }

    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        nBTTagCompound.setBoolean("Sheared", this.isSheared());
        nBTTagCompound.setByte("Color", (byte)this.getColor());
    }

    public void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        this.setSheared(nBTTagCompound.getBoolean("Sheared"));
        this.setColor(nBTTagCompound.getByte("Color"));
    }

    protected String aQ() {
        return "mob.sheep";
    }

    protected String aR() {
        return "mob.sheep";
    }

    protected String aS() {
        return "mob.sheep";
    }

    public int getColor() {
        return this.datawatcher.getByte(16) & 0xF;
    }

    public void setColor(int n) {
        byte by = this.datawatcher.getByte(16);
        this.datawatcher.watch(16, (byte)(by & 0xF0 | n & 0xF));
    }

    public boolean isSheared() {
        return (this.datawatcher.getByte(16) & 0x10) != 0;
    }

    public void setSheared(boolean bl) {
        byte by = this.datawatcher.getByte(16);
        if (bl) {
            this.datawatcher.watch(16, (byte)(by | 0x10));
        } else {
            this.datawatcher.watch(16, (byte)(by & 0xFFFFFFEF));
        }
    }

    public static int a(Random random) {
        int n = random.nextInt(100);
        if (n < 5) {
            return 15;
        }
        if (n < 10) {
            return 7;
        }
        if (n < 15) {
            return 8;
        }
        if (n < 18) {
            return 12;
        }
        if (random.nextInt(500) == 0) {
            return 6;
        }
        return 0;
    }

    public EntityAnimal createChild(EntityAnimal entityAnimal) {
        EntitySheep entitySheep = (EntitySheep)entityAnimal;
        EntitySheep entitySheep2 = new EntitySheep(this.world);
        if (this.random.nextBoolean()) {
            entitySheep2.setColor(this.getColor());
        } else {
            entitySheep2.setColor(entitySheep.getColor());
        }
        return entitySheep2;
    }

    public void aA() {
        this.setSheared(false);
        if (this.isBaby()) {
            int n = this.getAge() + 1200;
            if (n > 0) {
                n = 0;
            }
            this.setAge(n);
        }
    }
}

