/*
 * Decompiled with CFR 0.152.
 */
package com.wolvereness.overmapped.lib;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;

public final class WellOrdered {
    private WellOrdered() {
    }

    private static <T> void addToAsLinkedList(T token, Map<T, Collection<T>> map, Collection<T> tokens) {
        LinkedList c = map.get(token);
        if (c == null) {
            c = Lists.newLinkedList();
            map.put(token, c);
        }
        c.addAll(tokens);
    }

    private static <T> void addToAllLinkedLists(Collection<T> tokens, Map<T, Collection<T>> map, T token) {
        for (T target : tokens) {
            LinkedList c = map.get(target);
            if (c == null) {
                c = Lists.newLinkedList();
                map.put(target, c);
            }
            c.add(token);
        }
    }

    private static <T> boolean handleTokens(T token, Map<T, Collection<T>> map, Set<T> in) {
        Iterator<T> it = WellOrdered.getIterator(token, map);
        if (it == null) {
            return true;
        }
        while (it.hasNext()) {
            if (in.contains(it.next())) {
                return false;
            }
            it.remove();
        }
        map.remove(token);
        return true;
    }

    private static <T> Iterator<T> getIterator(T token, Map<T, Collection<T>> map) {
        Collection<T> c = map.get(token);
        if (c == null) {
            return null;
        }
        return c.iterator();
    }

    public static <T, C extends List<? super T>> C process(C out, Iterable<? extends T> in, Informer<T> informer) throws WellOrderedException {
        Validate.notNull(out, (String)"Collection out cannot be null", (Object[])new Object[0]);
        Validate.notNull(in, (String)"Token in cannot be null", (Object[])new Object[0]);
        Validate.notNull(informer, (String)"Informer cannot be null", (Object[])new Object[0]);
        HashMap preceding = Maps.newHashMap();
        HashMap required = Maps.newHashMap();
        LinkedHashSet pending = Sets.newLinkedHashSet(in);
        ArrayList buffer = Lists.newArrayList();
        for (Object token : pending) {
            informer.addPrecedingPreferencesTo(token, buffer);
            WellOrdered.addToAsLinkedList(token, preceding, buffer);
            buffer.clear();
            informer.addPrecedingTo(token, buffer);
            if (!pending.containsAll(buffer)) {
                throw new UnmetPrecedingTokenException(token + " cannot be proceded by one of " + buffer + " with only " + pending + " available");
            }
            WellOrdered.addToAsLinkedList(token, required, buffer);
            buffer.clear();
            informer.addProceedingPreferencesTo(token, buffer);
            WellOrdered.addToAllLinkedLists(buffer, preceding, token);
            buffer.clear();
        }
        int size = pending.size();
        while (size != 0) {
            Object token;
            Iterator tokenIterator = pending.iterator();
            while (tokenIterator.hasNext()) {
                token = tokenIterator.next();
                if (!WellOrdered.handleTokens(token, preceding, pending) || !WellOrdered.handleTokens(token, required, pending)) continue;
                tokenIterator.remove();
                out.add(token);
            }
            if (size != (size = pending.size())) continue;
            tokenIterator = pending.iterator();
            while (tokenIterator.hasNext()) {
                token = tokenIterator.next();
                if (!WellOrdered.handleTokens(token, required, pending)) continue;
                tokenIterator.remove();
                preceding.remove(token);
                out.add(token);
                break;
            }
            if (size != (size = pending.size())) continue;
            break;
        }
        if (size != 0) {
            throw new CircularOrderException("Failed to resolve circular preceding requirements in " + required);
        }
        return out;
    }

    public static abstract class AbstractInformer<T>
    implements Informer<T> {
        @Override
        public void addPrecedingTo(T token, Collection<? super T> of) {
        }

        @Override
        public void addPrecedingPreferencesTo(T token, Collection<? super T> of) {
        }

        @Override
        public void addProceedingPreferencesTo(T token, Collection<? super T> of) {
        }
    }

    public static interface Informer<T> {
        public void addPrecedingTo(T var1, Collection<? super T> var2);

        public void addPrecedingPreferencesTo(T var1, Collection<? super T> var2);

        public void addProceedingPreferencesTo(T var1, Collection<? super T> var2);
    }

    public static class UnmetPrecedingTokenException
    extends WellOrderedException {
        private static final long serialVersionUID = 1L;

        UnmetPrecedingTokenException() {
        }

        UnmetPrecedingTokenException(String message, Throwable cause) {
            super(message, cause);
        }

        UnmetPrecedingTokenException(String message) {
            super(message);
        }

        UnmetPrecedingTokenException(Throwable cause) {
            super(cause);
        }
    }

    public static class CircularOrderException
    extends WellOrderedException {
        private static final long serialVersionUID = 1L;

        CircularOrderException() {
        }

        CircularOrderException(String message, Throwable cause) {
            super(message, cause);
        }

        CircularOrderException(String message) {
            super(message);
        }

        CircularOrderException(Throwable cause) {
            super(cause);
        }
    }

    public static class WellOrderedException
    extends Exception {
        private static final long serialVersionUID = 1L;

        WellOrderedException() {
        }

        WellOrderedException(String message, Throwable cause) {
            super(message, cause);
        }

        WellOrderedException(String message) {
            super(message);
        }

        WellOrderedException(Throwable cause) {
            super(cause);
        }
    }
}

