/*
 * Decompiled with CFR 0.152.
 */
package com.wolvereness.overmapped.lib;

import com.wolvereness.overmapped.lib.MultiProcessor;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

final class SingletonProcessor
extends MultiProcessor {
    SingletonProcessor() {
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        super.checkShutdown();
        try {
            final T object = task.call();
            return new Future<T>(){

                @Override
                public boolean cancel(boolean mayInterruptIfRunning) {
                    return false;
                }

                @Override
                public boolean isCancelled() {
                    return false;
                }

                @Override
                public boolean isDone() {
                    return true;
                }

                @Override
                public T get() throws InterruptedException, ExecutionException {
                    return object;
                }

                @Override
                public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                    return object;
                }
            };
        }
        catch (Exception exception) {
            final Exception ex = exception;
            return new Future<T>(){

                @Override
                public boolean cancel(boolean mayInterruptIfRunning) {
                    return false;
                }

                @Override
                public boolean isCancelled() {
                    return false;
                }

                @Override
                public boolean isDone() {
                    return true;
                }

                @Override
                public T get() throws InterruptedException, ExecutionException {
                    throw new ExecutionException(ex);
                }

                @Override
                public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                    throw new ExecutionException(ex);
                }
            };
        }
    }
}

