/*
 * Decompiled with CFR 0.152.
 */
package com.wolvereness.overmapped.asm;

import java.util.Map;

public class Signature {
    @Deprecated
    String clazz;
    @Deprecated
    String name;
    @Deprecated
    String descriptor;
    @Deprecated
    int hash;

    Signature(String clazz, String name, String signature) {
        this.clazz = clazz;
        this.name = name;
        this.descriptor = signature;
        this.hash = Signature.hash(clazz, name, signature);
    }

    public static Signature newSignature(String clazz, String name, String signature) {
        return new Signature(clazz, name, signature);
    }

    public static MutableSignature newMutableSignature(String clazz, String name, String signature) {
        return new MutableSignature(clazz, name, signature);
    }

    static int hash(String clazz, String name, String signature) {
        int hash = 1;
        hash = 31 * hash + clazz.hashCode();
        hash = 31 * hash + name.hashCode();
        hash = 31 * hash + signature.hashCode();
        return hash;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Signature)) {
            return false;
        }
        return this.equals((Signature)obj);
    }

    private boolean equals(Signature signature) {
        return this.hash == signature.hash && this.clazz.equals(signature.clazz) && this.name.equals(signature.name) && this.descriptor.equals(signature.descriptor);
    }

    public String getClassName() {
        return this.clazz;
    }

    public String getElementName() {
        return this.name;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public Signature forClassName(String clazz) {
        return new Signature(clazz, this.name, this.descriptor);
    }

    public Signature forElementName(String name) {
        return new Signature(this.clazz, name, this.descriptor);
    }

    public boolean isMethod() {
        return this.descriptor.charAt(0) == '(';
    }

    public String toString() {
        return this.toMappable();
    }

    private String toMappable() {
        return this.clazz + '.' + this.name + ' ' + this.descriptor;
    }

    public static class MutableSignature
    extends Signature {
        MutableSignature(String clazz, String name, String signature) {
            super(clazz, name, signature);
        }

        public MutableSignature update(String clazz, String name, String signature, Map<Signature, Signature> signatures) {
            this.clazz = clazz;
            this.name = name;
            this.descriptor = signature;
            this.hash = MutableSignature.hash(clazz, name, signature);
            Signature value = signatures.get(this);
            if (value != null) {
                this.clazz = value.clazz;
                this.name = value.name;
                this.descriptor = value.descriptor;
                this.hash = value.hash;
            }
            return this;
        }

        public <T> T updateAndGet(String clazz, String name, String signature, Map<Signature, T> map, T def) {
            T value = map.get(this.update(clazz, name, signature));
            if (value == null) {
                return def;
            }
            return value;
        }

        public MutableSignature update(String clazz, String name, String signature) {
            this.clazz = clazz;
            this.name = name;
            this.descriptor = signature;
            this.hash = MutableSignature.hash(clazz, name, signature);
            return this;
        }
    }
}

